<?php

namespace CfdiUtils\Elements\Cce20;

use CfdiUtils\Elements\Common\AbstractElement;

class Emisor extends AbstractElement
{
    public function getElementName(): string
    {
        return 'cce20:Emisor';
    }
	public function getCurp(): string
	{
		return $this->attributes()->get('Curp');
	}

	public function addCurp(string $curp): self
	{
		$this->attributes()->set('Curp', $curp);
		return $this;
	}

    public function getDomicilio(): Domicilio
    {
        return $this->helperGetOrAdd(new Domicilio());
    }

    public function addDomicilio(array $attributes = []): Domicilio
    {
        $subject = $this->getDomicilio();
        $subject->addAttributes($attributes);
        return $subject;
    }
}
