CREATE TABLE llx_cfdixml_facture_global_det
(
    rowid             INT AUTO_INCREMENT PRIMARY KEY,
    fk_factura_global INT                 NOT NULL, -- Relación con la factura global
    fk_facture        INT                 NOT NULL, -- ID del ticket original
    ref               VARCHAR(30)         NOT NULL, -- Referencia del ticket
    total_ht double(24,8) DEFAULT 0,                -- Subtotal del ticket
    total_tva double(24,8) DEFAULT 0,               -- IVA del ticket
    total_ttc double(24,8) DEFAULT 0,               -- Total del ticket
    discount double(24,8) DEFAULT 0,                -- Descuento aplicado
    date_creation     datetime            NOT NULL, -- Fecha de creación
    tms               timestamp DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    entity            integer   DEFAULT 1 NOT NULL, -- Entidad
    CONSTRAINT fk_facture_global FOREIGN KEY (fk_facture_global) REFERENCES llx_cfdixml_facture_global (rowid),
    CONSTRAINT fk_facture FOREIGN KEY (fk_facture) REFERENCES llx_facture (rowid)
);
