CREATE TABLE llx_cfdixml_facture_global
(
    rowid          INT AUTO_INCREMENT PRIMARY KEY,
    ref            VARCHAR(30)         NOT NULL, -- Referencia única
    fk_soc         INT                 NOT NULL, -- Tercero (público en general)
    periodo_inicio DATE                NOT NULL, -- Fecha inicio del período
    periodo_fin    DATE                NOT NULL, -- Fecha fin del período
    forma_pago     VARCHAR(10)         NOT NULL, -- Forma de pago SAT
    metodo_pago    VARCHAR(3)          NOT NULL, -- Método de pago SAT
    total_ht double(24,8) DEFAULT 0,             -- Subtotal
    total_tva double(24,8) DEFAULT 0,            -- IVA
    total_ttc double(24,8) DEFAULT 0,            -- Total
    date_creation  datetime            NOT NULL, -- Fecha de creación
    tms            timestamp DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    fk_user_create integer             NOT NULL, -- Usuario que crea
    fk_user_modif  integer,                      -- Usuario que modifica
    status         smallint  DEFAULT 0,          -- Estado
    uuid           VARCHAR(36),                  -- UUID del CFDI
    entity         integer   DEFAULT 1 NOT NULL  -- Entidad
);
