-- Tabla maestra de addendas disponibles
CREATE TABLE llx_cfdixml_addenda (
    rowid INT AUTO_INCREMENT PRIMARY KEY,
    addenda VARCHAR(128) NOT NULL,              -- Nombre de la addenda
    class VARCHAR(255) NOT NULL,                -- Nombre y ruta de la clase
    fk_status TINYINT DEFAULT 0,               -- Estado de la addenda (0: inactivo, 1: activo)
    entity INT DEFAULT 1,                       -- ID de la entidad
    tms timestamp DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    UNIQUE KEY uk_cfdixml_addenda (addenda, entity)
) ENGINE=InnoDB;

-- Tabla para almacenar la configuración de extrafields de las addendas
CREATE TABLE llx_cfdixml_addenda_extrafields (
    rowid INT AUTO_INCREMENT PRIMARY KEY,
    fk_addenda INT NOT NULL,                    -- ID de la addenda relacionada
    attrname VARCHAR(128) NOT NULL,             -- Código del atributo
    label VARCHAR(255) NOT NULL,                -- Etiqueta del atributo
    type VARCHAR(64) NOT NULL,                  -- Tipo de atributo
    pos INT DEFAULT 0,                          -- Posición
    size VARCHAR(64),                           -- Tamaño/longitud
    elementtype VARCHAR(64) NOT NULL,           -- Tipo de elemento (member, product, thirdparty...)
    unique_field TINYINT DEFAULT 0,             -- Campo único
    required TINYINT DEFAULT 0,                 -- Campo requerido
    default_value VARCHAR(255),                 -- Valor por defecto
    param TEXT,                                 -- Parámetros adicionales (serializado)
    alwayseditable TINYINT DEFAULT 0,           -- Siempre editable
    perms VARCHAR(255),                         -- Permisos necesarios
    list VARCHAR(64) DEFAULT '-1',              -- Visibilidad
    help TEXT,                                  -- Texto de ayuda
    computed TEXT,                              -- Valor calculado
    entity INT DEFAULT 1,                       -- Entidad
    langfile VARCHAR(255),                      -- Archivo de idioma
    enabled VARCHAR(255) DEFAULT '1',           -- Condición de habilitación
    totalizable TINYINT DEFAULT 0,              -- Es totalizable
    printable TINYINT DEFAULT 0,                -- Se muestra en PDF
    moreparams TEXT,                            -- Parámetros adicionales (serializado)
    tms timestamp DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    UNIQUE KEY uk_cfdixml_addenda_extrafields_attrname (fk_addenda, attrname),
    CONSTRAINT fk_cfdixml_addenda_extrafields_addenda FOREIGN KEY (fk_addenda) REFERENCES llx_cfdixml_addenda (rowid)
) ENGINE=InnoDB;

-- Tabla principal de configuración para la addenda Soriana
CREATE TABLE llx_cfdixml_addenda_soriana (
    rowid INT AUTO_INCREMENT PRIMARY KEY,
    fk_societe INT NOT NULL,                    -- ID del tercero
    codigo_proveedor VARCHAR(50) NOT NULL,      -- Código de proveedor asignado por Soriana
    tipo_moneda TINYINT DEFAULT 1,              -- Config por defecto tipo moneda
    tipo_bulto TINYINT DEFAULT 1,               -- Config por defecto tipo de bulto
    entity INT DEFAULT 1,                       -- ID de la entidad
    tms timestamp DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    UNIQUE KEY uk_cfdixml_addenda_soriana_societe (fk_societe, entity),
    CONSTRAINT fk_cfdixml_addenda_soriana_societe FOREIGN KEY (fk_societe) REFERENCES llx_societe (rowid)
) ENGINE=InnoDB;

-- Tabla para datos de pedidos
CREATE TABLE llx_cfdixml_addenda_soriana_commande (
    rowid INT AUTO_INCREMENT PRIMARY KEY,
    fk_commande INT NOT NULL,                   -- ID del pedido
    remision VARCHAR(50),                       -- Número de remisión (formato CA-XXXXX)
    folio_pedido VARCHAR(50),                   -- Ref del pedido
    cantidad_articulos INT,                     -- Cantidad de artículos diferentes
    entity INT DEFAULT 1,                       -- ID de la entidad
    fk_user_author INT,                         -- Usuario que creó
    fk_user_modif INT,                          -- Usuario que modificó
    datec DATETIME,                             -- Fecha de creación
    tms timestamp DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    UNIQUE KEY uk_addenda_soriana_commande (fk_commande, entity),
    CONSTRAINT fk_addenda_soriana_commande FOREIGN KEY (fk_commande) REFERENCES llx_commande (rowid)
) ENGINE=InnoDB;

-- Tabla para datos de envíos
CREATE TABLE llx_cfdixml_addenda_soriana_expedition (
    rowid INT AUTO_INCREMENT PRIMARY KEY,
    fk_expedition INT NOT NULL,                 -- ID del envío
    remision VARCHAR(50),                       -- Número de remisión
    consecutivo INT DEFAULT 0,                  -- Consecutivo
    fecha_remision DATETIME,                    -- Fecha de remisión
    tipo_bulto TINYINT DEFAULT 1,              -- Tipo de bulto
    cantidad_bultos INT,                        -- Cantidad de bultos
    fecha_entrega DATETIME,                     -- Fecha programada de entrega
    empaque_cajas TINYINT(1) DEFAULT 1,         -- Empaque en cajas
    empaque_tarimas TINYINT(1) DEFAULT 1,       -- Empaque en tarimas
    cantidad_cajas_tarimas INT,                 -- Cantidad cajas/tarimas
    cita VARCHAR(50),                           -- Número de cita
    entity INT DEFAULT 1,                       -- ID de la entidad
    fk_user_author INT,                         -- Usuario que creó
    fk_user_modif INT,                          -- Usuario que modificó
    datec DATETIME,                             -- Fecha de creación
    tms timestamp DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    UNIQUE KEY uk_addenda_soriana_expedition (fk_expedition, entity),
    CONSTRAINT fk_addenda_soriana_expedition FOREIGN KEY (fk_expedition) REFERENCES llx_expedition (rowid)
) ENGINE=InnoDB;

-- Tabla para el detalle de artículos en envíos de addenda Soriana
CREATE TABLE llx_cfdixml_addenda_soriana_expedition_det (
    rowid INT AUTO_INCREMENT PRIMARY KEY,
    fk_expedition_line INT NOT NULL,            -- ID de la línea de envío
    fk_expedition INT NOT NULL,                 -- ID del envío
    codigo VARCHAR(50) NOT NULL,                -- Código del artículo
    cantidad_unidad DOUBLE(24,8) NOT NULL,      -- Cantidad de unidades
    costo_neto DOUBLE(24,8) NOT NULL,          -- Costo unitario
    porcentaje_ieps DOUBLE(24,8) DEFAULT 0,     -- Porcentaje IEPS
    porcentaje_iva DOUBLE(24,8) DEFAULT 0,      -- Porcentaje IVA
    entity INT DEFAULT 1,                       -- ID de la entidad
    tms timestamp DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    UNIQUE KEY uk_addenda_soriana_exp_det (fk_expedition_line, entity),
    CONSTRAINT fk_addenda_soriana_exp_det_exp FOREIGN KEY (fk_expedition) REFERENCES llx_expedition (rowid),
    CONSTRAINT fk_addenda_soriana_exp_det_line FOREIGN KEY (fk_expedition_line) REFERENCES llx_expeditiondet (rowid)
) ENGINE=InnoDB;
