<?php
/* Copyright (C) 2024 Your Name <your@email.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

/**
 *  \file       cfdixml/facturaglobal_card.php
 *  \ingroup    cfdixml
 *  \brief      Page to create/view factura global
 */

// Load Dolibarr environment
$res = 0;
// Try main.inc.php into web root known defined into CONTEXT_DOCUMENT_ROOT (not always defined)
if (!$res && !empty($_SERVER["CONTEXT_DOCUMENT_ROOT"])) {
	$res = @include $_SERVER["CONTEXT_DOCUMENT_ROOT"] . "/main.inc.php";
}
// Try main.inc.php into web root detected using web root calculated from SCRIPT_FILENAME
$tmp = empty($_SERVER['SCRIPT_FILENAME']) ? '' : $_SERVER['SCRIPT_FILENAME'];
$tmp2 = realpath(__FILE__);
$i = strlen($tmp) - 1;
$j = strlen($tmp2) - 1;
while ($i > 0 && $j > 0 && isset($tmp[$i]) && isset($tmp2[$j]) && $tmp[$i] == $tmp2[$j]) {
	$i--;
	$j--;
}
if (!$res && $i > 0 && file_exists(substr($tmp, 0, ($i + 1)) . "/main.inc.php")) {
	$res = @include substr($tmp, 0, ($i + 1)) . "/main.inc.php";
}
if (!$res && $i > 0 && file_exists(dirname(substr($tmp, 0, ($i + 1))) . "/main.inc.php")) {
	$res = @include dirname(substr($tmp, 0, ($i + 1))) . "/main.inc.php";
}
// Try main.inc.php using relative path
if (!$res && file_exists("../main.inc.php")) {
	$res = @include "../main.inc.php";
}
if (!$res && file_exists("../../main.inc.php")) {
	$res = @include "../../main.inc.php";
}
if (!$res && file_exists("../../../main.inc.php")) {
	$res = @include "../../../main.inc.php";
}
if (!$res) {
	die("Include of main fails");
}

require_once DOL_DOCUMENT_ROOT.'/core/class/html.formfile.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formother.class.php';
require_once DOL_DOCUMENT_ROOT.'/compta/facture/class/facture.class.php';
dol_include_once('/cfdixml/class/factureglobal.class.php');
dol_include_once('/cfdixml/lib/factureglobal.lib.php');

// Load translation files
$langs->loadLangs(array("cfdixml@cfdixml", "bills", "companies"));

// Get parameters
$id = GETPOST('id', 'int');
$action = GETPOST('action', 'aZ09');

// Initialize objects
$object = new FactureGlobal($db);
$form = new Form($db);
$formfile = new FormFile($db);
$formother = new FormOther($db);

// Fetch parameters
$date_start = GETPOST('date_start') ? dol_mktime(0, 0, 0, GETPOST('date_startmonth'), GETPOST('date_startday'), GETPOST('date_startyear')) : '';
$date_end = GETPOST('date_end') ? dol_mktime(23, 59, 59, GETPOST('date_endmonth'), GETPOST('date_endday'), GETPOST('date_endyear')) : '';
$payment_mode = GETPOST('payment_mode', 'int');

/*
 * Actions
 */

if ($action == 'search') {
	// Here we'll process the search and display results
}

/*
 * View
 */

$title = $langs->trans("GlobalInvoice");
llxHeader('', $title);

print load_fiche_titre($title, '', 'bill');
$head = cfdixmlInvoiceGlobalPrepareHead($object);
print dol_get_fiche_head($head, 'card', $langs->trans("GlobalInvoice"), -1, 'bill');
// Filter form
print '<form method="POST" action="'.$_SERVER["PHP_SELF"].'">';
print '<input type="hidden" name="token" value="'.newToken().'">';
print '<input type="hidden" name="action" value="search">';

print '<div class="fichecenter">';


print '<table class="border" width="100%">';

// Period
print '<tr>';
print '<td class="titlefield">'.$langs->trans("Period").'</td>';
print '<td>';
print $form->selectDate($date_start, 'date_start', 0, 0, 1, '', 1, 1);
print ' - ';
print $form->selectDate($date_end, 'date_end', 0, 0, 1, '', 1, 1);
print '</td>';
print '</tr>';

// Payment mode
print '<tr>';
print '<td>'.$langs->trans("PaymentMode").'</td>';
print '<td>';
$form->select_types_paiements($payment_mode, 'payment_mode', '', 0, 1, 1, 0, 1);
print '</td>';
print '</tr>';

print '</table>';


print '</div>';

// Buttons
print '<div class="center">';
print '<input type="submit" class="button" name="search" value="'.$langs->trans("Search").'">';
print '</div>';

print '</form>';

// Results section
if ($action == 'search' && !empty($date_start) && !empty($date_end)) {
	print '<br>';

	// Build SQL query
	$sql = "SELECT f.rowid, f.ref, f.datef, f.total_ht, f.total_tva, f.total_ttc,";
	$sql.= " f.fk_mode_reglement, cp.code as payment_code, cp.libelle as payment_label";
	$sql.= " FROM ".MAIN_DB_PREFIX."facture as f";
	$sql.= " LEFT JOIN ".MAIN_DB_PREFIX."c_paiement as cp ON cp.id = f.fk_mode_reglement";
	$sql.= " WHERE f.entity IN (".getEntity('invoice').")";
	$sql.= " AND f.module_source = 'takepos'";
	$sql.= " AND f.datef BETWEEN '".$db->idate($date_start)."' AND '".$db->idate($date_end)."'";
	if ($payment_mode > 0) {
		$sql.= " AND f.fk_mode_reglement = ".$payment_mode;
	}
	$sql .= " AND f.fk_statut IN (2)"; // 2 = validated, 4 = partially paid
	$sql.= " ORDER BY f.datef ASC";
echo $sql;
	$resql = $db->query($sql);
	if ($resql) {
		$num = $db->num_rows($resql);

		print '<div class="div-table-responsive">';
		print '<table class="tagtable liste">';
		print '<tr class="liste_titre">';
		print '<td>'.$langs->trans("Ref").'</td>';
		print '<td>'.$langs->trans("Date").'</td>';
		print '<td>'.$langs->trans("PaymentMode").'</td>';
		print '<td class="right">'.$langs->trans("AmountHT").'</td>';
		print '<td class="right">'.$langs->trans("AmountVAT").'</td>';
		print '<td class="right">'.$langs->trans("AmountTTC").'</td>';
		print '<td class="center">'.$langs->trans("Select").'</td>';
		print '</tr>';

		if ($num > 0) {
			$total_ht = $total_tva = $total_ttc = 0;

			while ($obj = $db->fetch_object($resql)) {
				print '<tr class="oddeven">';
				print '<td>'.$obj->ref.'</td>';
				print '<td>'.dol_print_date($db->jdate($obj->datef), 'day').'</td>';
				print '<td>'.$obj->payment_label.'</td>';
				print '<td class="right">'.price($obj->total_ht).'</td>';
				print '<td class="right">'.price($obj->total_tva).'</td>';
				print '<td class="right">'.price($obj->total_ttc).'</td>';
				print '<td class="center">';
				print '<input type="checkbox" name="toselect[]" value="'.$obj->rowid.'">';
				print '</td>';
				print '</tr>';

				$total_ht += $obj->total_ht;
				$total_tva += $obj->total_tva;
				$total_ttc += $obj->total_ttc;
			}

			// Show totals
			print '<tr class="liste_total">';
			print '<td colspan="3">'.$langs->trans("Total").'</td>';
			print '<td class="right">'.price($total_ht).'</td>';
			print '<td class="right">'.price($total_tva).'</td>';
			print '<td class="right">'.price($total_ttc).'</td>';
			print '<td></td>';
			print '</tr>';
		} else {
			print '<tr><td colspan="7"><span class="opacitymedium">'.$langs->trans("NoRecordFound").'</span></td></tr>';
		}

		print '</table>';
		print '</div>';

		if ($num > 0) {
			print '<div class="tabsAction">';
			print '<input type="submit" class="butAction" name="generate" value="'.$langs->trans("GenerateGlobalInvoice").'">';
			print '</div>';
		}
	}
}

// End of page
llxFooter();
$db->close();
