<?php
// Load Dolibarr environment
$res = 0;
// Try main.inc.php into web root known defined into CONTEXT_DOCUMENT_ROOT (not always defined)
if (!$res && !empty($_SERVER["CONTEXT_DOCUMENT_ROOT"])) {
	$res = @include $_SERVER["CONTEXT_DOCUMENT_ROOT"]."/main.inc.php";
}
// Try main.inc.php into web root detected using web root calculated from SCRIPT_FILENAME
$tmp = empty($_SERVER['SCRIPT_FILENAME']) ? '' : $_SERVER['SCRIPT_FILENAME']; $tmp2 = realpath(__FILE__); $i = strlen($tmp) - 1; $j = strlen($tmp2) - 1;
while ($i > 0 && $j > 0 && isset($tmp[$i]) && isset($tmp2[$j]) && $tmp[$i] == $tmp2[$j]) {
	$i--; $j--;
}
if (!$res && $i > 0 && file_exists(substr($tmp, 0, ($i + 1))."/main.inc.php")) {
	$res = @include substr($tmp, 0, ($i + 1))."/main.inc.php";
}
if (!$res && $i > 0 && file_exists(dirname(substr($tmp, 0, ($i + 1)))."/main.inc.php")) {
	$res = @include dirname(substr($tmp, 0, ($i + 1)))."/main.inc.php";
}
// Try main.inc.php using relative path
if (!$res && file_exists("../main.inc.php")) {
	$res = @include "../main.inc.php";
}
if (!$res && file_exists("../../main.inc.php")) {
	$res = @include "../../main.inc.php";
}
if (!$res && file_exists("../../../main.inc.php")) {
	$res = @include "../../../main.inc.php";
}
if (!$res) {
	die("Include of main fails");
}
function dumpCertificado($certificadoPath)
{
    try {
        // Convertir a PEM y leer certificado
        $datos = file_get_contents($certificadoPath);
        if (strpos($datos, '-----BEGIN CERTIFICATE-----') === false) {
            $base64 = base64_encode($datos);
            $datos = "-----BEGIN CERTIFICATE-----\n" .
                    chunk_split($base64, 64, "\n") .
                    "-----END CERTIFICATE-----\n";
        }

        $cert = openssl_x509_read($datos);
        if (!$cert) {
            return [
                'error' => true,
                'mensaje' => 'Error leyendo certificado: ' . openssl_error_string()
            ];
        }

        $certData = openssl_x509_parse($cert);
        openssl_x509_free($cert);

        // Dump completo del certificado
        echo "<pre>";
        print_r([
            'Estructura completa' => $certData,
            'Subject' => $certData['subject'] ?? 'No disponible',
            'Issuer' => $certData['issuer'] ?? 'No disponible',
            'Validez' => [
                'Desde' => date('Y-m-d H:i:s', $certData['validFrom_time_t']),
                'Hasta' => date('Y-m-d H:i:s', $certData['validTo_time_t'])
            ],
            'Extensions' => $certData['extensions'] ?? 'No disponible',
            'Serial Number' => $certData['serialNumber'] ?? 'No disponible',
            'Serial Number (Hex)' => $certData['serialNumberHex'] ?? 'No disponible'
        ]);
        echo "</pre>";

        return true;
    } catch (Exception $e) {
        return [
            'error' => true,
            'mensaje' => 'Error analizando certificado: ' . $e->getMessage()
        ];
    }
}
dumpCertificado($conf->global->CFDIXML_CER_FILE);
exit;
dol_include_once('/cfdixml/class/cfdi/Certificado.php');
// En tu código donde procesas el CFDI
$certificado = new Certificado();
$debugInfo = $certificado->debugLlavePrivada(
    $conf->global->CFDIXML_KEY_FILE,
    $conf->global->CFDIXML_CERKEY_PASS
);
var_dump($debugInfo);
