<?php
/* Copyright (C) 2022 SuperAdmin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

/**
 * \file    core/triggers/interface_99_modCfdixml_CfdixmlTriggers.class.php
 * \ingroup cfdixml
 * \brief   Example trigger.
 *
 * Put detailed description here.
 *
 * \remarks You can create other triggers by copying this one.
 * - File name should be either:
 *      - interface_99_modCfdixml_MyTrigger.class.php
 *      - interface_99_all_MyTrigger.class.php
 * - The file must stay in core/triggers
 * - The class name must be InterfaceMytrigger
 */

use PhpParser\Node\Expr\Cast\Double;
use Sabre\VObject\Property\FloatValue;

require_once DOL_DOCUMENT_ROOT . '/core/triggers/dolibarrtriggers.class.php';
dol_include_once('/cfdixml/lib/cfdixml.lib.php');

/**
 *  Class of triggers for Cfdixml module
 */
class InterfaceCfdixmlTriggers extends DolibarrTriggers
{
	/**
	 * Constructor
	 *
	 * @param DoliDB $db Database handler
	 */
	public function __construct($db)
	{
		$this->db = $db;

		$this->name = preg_replace('/^Interface/i', '', get_class($this));
		$this->family = "demo";
		$this->description = "Cfdixml triggers.";
		// 'development', 'experimental', 'dolibarr' or version
		$this->version = 'development';
		$this->picto = 'cfdixml@cfdixml';
	}

	/**
	 * Trigger name
	 *
	 * @return string Name of trigger file
	 */
	public function getName()
	{
		return $this->name;
	}

	/**
	 * Trigger description
	 *
	 * @return string Description of trigger file
	 */
	public function getDesc()
	{
		return $this->description;
	}


	/**
	 *
	 */

	private function _amount(float $percent, float $amount): float
	{

		return (($amount * $percent) / 100);
	}

	/**
	 * Function called when a Dolibarrr business event is done.
	 * All functions "runTrigger" are triggered if file
	 * is inside directory core/triggers
	 *
	 * @param string $action Event action code
	 * @param CommonObject $object Object
	 * @param User $user Object user
	 * @param Translate $langs Object langs
	 * @param Conf $conf Object conf
	 * @return int                    <0 if KO, 0 if no triggered ran, >0 if OK
	 */
	public function runTrigger($action, $object, User $user, Translate $langs, Conf $conf)
	{
		global $conf;
		if (empty($conf->cfdixml) || empty($conf->cfdixml->enabled)) {
			return 0; // If module is not enabled, we do nothing
		}

		// Put here code you want to execute when a Dolibarr business events occurs.
		// Data and type of action are stored into $object and $action

		// You can isolate code for each action in a separate method: this method should be named like the trigger in camelCase.
		// For example : COMPANY_CREATE => public function companyCreate($action, $object, User $user, Translate $langs, Conf $conf)
		$methodName = lcfirst(str_replace(' ', '', ucwords(str_replace('_', ' ', strtolower($action)))));
		$callback = array($this, $methodName);
		if (is_callable($callback)) {
			dol_syslog(
				"Trigger '" . $this->name . "' for action '$action' launched by " . __FILE__ . ". id=" . $object->id
			);

			return call_user_func($callback, $action, $object, $user, $langs, $conf);
		};

		// echo $action;exit;

		// Or you can execute some code here
		switch ($action) {

			// Users
			//case 'USER_CREATE':
			//case 'USER_MODIFY':
			//case 'USER_NEW_PASSWORD':
			//case 'USER_ENABLEDISABLE':
			//case 'USER_DELETE':

			// Actions
			//case 'ACTION_MODIFY':
			//case 'ACTION_CREATE':
			//case 'ACTION_DELETE':

			// Groups
			//case 'USERGROUP_CREATE':
			//case 'USERGROUP_MODIFY':
			//case 'USERGROUP_DELETE':

			// Companies
			//case 'COMPANY_CREATE':
			//case 'COMPANY_MODIFY':
			//case 'COMPANY_DELETE':

			// Contacts
			//case 'CONTACT_CREATE':
			//case 'CONTACT_MODIFY':
			//case 'CONTACT_DELETE':
			//case 'CONTACT_ENABLEDISABLE':

			// Products
			//case 'PRODUCT_CREATE':
			//case 'PRODUCT_MODIFY':
			//case 'PRODUCT_DELETE':
			//case 'PRODUCT_PRICE_MODIFY':
			//case 'PRODUCT_SET_MULTILANGS':
			//case 'PRODUCT_DEL_MULTILANGS':

			//Stock mouvement
			//case 'STOCK_MOVEMENT':

			//MYECMDIR
			//case 'MYECMDIR_CREATE':
			//case 'MYECMDIR_MODIFY':
			//case 'MYECMDIR_DELETE':

			// Customer orders
			//case 'ORDER_CREATE':
			//case 'ORDER_MODIFY':
			//case 'ORDER_VALIDATE':
			//case 'ORDER_DELETE':
			//case 'ORDER_CANCEL':
			//case 'ORDER_SENTBYMAIL':
			//case 'ORDER_CLASSIFY_BILLED':
			//case 'ORDER_SETDRAFT':
			case 'LINEORDER_INSERT':
				global $mysoc;
				if($action == 'confirm_clone' && GETPOST('confirm') == 'yes') {
					break;
				}
				if (strlen($mysoc->idprof1) == 13) {
					if (isset($conf->global->CFDIXML_RESICO_125) && $conf->global->CFDIXML_RESICO_125 > 0) {
						//Get parameters
						$price_ht = GETPOST('price_ht', 'int');
						$price_ttc = GETPOST('price_ttc', 'float');
						$qty = GETPOST('qty', 'int');

						//Instance Object
						$facture = new Facture($this->db);
						$facture->fetch($object->fk_facture);
						$facture->fetch_thirdparty();

						if (strlen($facture->thirdparty->idprof1) == 12) {
							if (!empty($price_ht)) {
								$price_ht += $price_ht * (float)$conf->global->CFDIXML_RESICO_125;
								$object->subprice = number_format($price_ht, 2, '.', '');
								$object->total_ht = $object->subprice * $qty;
							}
							if (!empty($price_ttc)) {
								// Calcular price_ht a partir de price_ttc, considerando el IVA del 16%
								$price_ht = (float)$price_ttc / 1.16;
								// Incrementar el 1.25% directamente sobre price_ht y formatear el resultado
								$price_ht += $price_ht * (float)$conf->global->CFDIXML_RESICO_125;
								$object->subprice = number_format($price_ht, 2, '.', ''); // Redondeo a 2 decimales
								$object->total_ht = $object->subprice * $qty;
							}

							$object->update($user, 1);
						}
					}
				}
				break;
			//case 'LINEORDER_UPDATE':
			//case 'LINEORDER_DELETE':

			// Supplier orders
			//case 'ORDER_SUPPLIER_CREATE':
			//case 'ORDER_SUPPLIER_MODIFY':
			//case 'ORDER_SUPPLIER_VALIDATE':
			//case 'ORDER_SUPPLIER_DELETE':
			//case 'ORDER_SUPPLIER_APPROVE':
			//case 'ORDER_SUPPLIER_REFUSE':
			//case 'ORDER_SUPPLIER_CANCEL':
			//case 'ORDER_SUPPLIER_SENTBYMAIL':
			//case 'ORDER_SUPPLIER_DISPATCH':
			//case 'LINEORDER_SUPPLIER_DISPATCH':
			//case 'LINEORDER_SUPPLIER_CREATE':
			//case 'LINEORDER_SUPPLIER_UPDATE':
			//case 'LINEORDER_SUPPLIER_DELETE':

			// Proposals
			//case 'PROPAL_CREATE':
			//case 'PROPAL_MODIFY':
			//case 'PROPAL_VALIDATE':
			//case 'PROPAL_SENTBYMAIL':
			//case 'PROPAL_CLOSE_SIGNED':
			//case 'PROPAL_CLOSE_REFUSED':
			//case 'PROPAL_DELETE':
			//case 'LINEPROPAL_INSERT':
			//case 'LINEPROPAL_UPDATE':
			//case 'LINEPROPAL_DELETE':

			// SupplierProposal
			//case 'SUPPLIER_PROPOSAL_CREATE':
			//case 'SUPPLIER_PROPOSAL_MODIFY':
			//case 'SUPPLIER_PROPOSAL_VALIDATE':
			//case 'SUPPLIER_PROPOSAL_SENTBYMAIL':
			//case 'SUPPLIER_PROPOSAL_CLOSE_SIGNED':
			//case 'SUPPLIER_PROPOSAL_CLOSE_REFUSED':
			//case 'SUPPLIER_PROPOSAL_DELETE':
			//case 'LINESUPPLIER_PROPOSAL_INSERT':
			//case 'LINESUPPLIER_PROPOSAL_UPDATE':
			//case 'LINESUPPLIER_PROPOSAL_DELETE':

			// Contracts
			//case 'CONTRACT_CREATE':
			//case 'CONTRACT_MODIFY':
			//case 'CONTRACT_ACTIVATE':
			//case 'CONTRACT_CANCEL':
			//case 'CONTRACT_CLOSE':
			//case 'CONTRACT_DELETE':
			//case 'LINECONTRACT_INSERT':
			//case 'LINECONTRACT_UPDATE':
			//case 'LINECONTRACT_DELETE':

			// Bills
			case 'BILL_CREATE':
				// global $dolibarr_main_url_root;
				// $url = $dolibarr_main_url_root . $_SERVER['PHP_SELF'];

				if (GETPOST('action') == 'confirm_clone' && GETPOST('confirm') == 'yes') {

					$invoice = new Facture($this->db);
					$invoice->fetch($object->id);
					$invoice->array_options['options_cfdixml_UUID'] = '';
					$invoice->array_options['options_cfdixml_control'] = '';
					$invoice->array_options['options_cfdixml_usocfdi'] = '';
					$invoice->array_options['options_cfdixml_metodopago'] = '';
					$invoice->array_options['options_cfdixml_exportacion'] = '';
					$invoice->array_options['options_cfdixml_certsat'] = '';
					$invoice->array_options['options_cfdixml_certcfd'] = '';
					$invoice->update($user, 1);
				}

				break;
			// case 'BILL_MODIFY':
			// 	echo '<pre>';print_r($object);exit;
			// 	break;
			case 'BILL_VALIDATE':
				global $mysoc;
//				if (strlen($mysoc->idprof1) == 13) {
//					if (isset($conf->global->CFDIXML_RESICO_125) && $conf->global->CFDIXML_RESICO_125 > 0) {
//						if (strlen($object->thirdparty->idprof1) == 12) {
//							$retention = $conf->global->CFDIXML_RESICO_RETENTION ? $conf->global->CFDIXML_RESICO_RETENTION : 1.25;
//
//							// Obtener la factura
//							$facture = new Facture($this->db);
//							if ($facture->fetch($object->id) > 0) {
//								// Calcular el monto de retención
//								$revenuestamp = $facture->total_ttc * ((float)$retention / 100);
//
//								// Asignar el monto de retención a la propiedad 'revenuestamp'
//								$facture->revenuestamp = $revenuestamp;
//
//								// Restar el monto de retención del total TTC
//								$facture->total_ttc -= $revenuestamp;
//
//								// Iniciar transacción
//								$this->db->begin();
//								$result = $facture->update($user, 1);
//
//								// Confirmar o deshacer cambios
//								if ($result > 0) {
//									$this->db->commit();
//								} else {
//									$this->db->rollback();
//								}
//							} else {
//								echo "Error al obtener la factura con ID: {$object->id}";
//							}
//						}
//					}
//				}
				// $resico = checkReceptor($object);
				// // var_dump($resico);exit;
				// if (empty($resico)) {
				// 	break;
				// }

				// $revenuestamp = 0;
				// foreach($object->lines as $line){
				// 	echo $line->ref_ext;exit;
				// 	(float)$revenuestamp += (float)$line->ref_ext;

				// }

				// $facture = new Facture($this->db);
				// $facture->fetch($object->id);
				// $facture->revenuestamp = $revenuestamp;
				// $facture->total_ttc = $facture->total_ttc - $revenuestamp;
				// $this->db->begin();
				// $result = $facture->update($user,1);

				// if($result>0){
				// 	$this->db->commit();
				// } else{
				// 	$this->db->rollback();
				// }
				break;
			//case 'BILL_UNVALIDATE':
			//case 'BILL_SENTBYMAIL':
			//case 'BILL_CANCEL':
			//case 'BILL_DELETE':
			//case 'BILL_PAYED':
			case 'LINEBILL_INSERT':

				global $mysoc;
				if($action == 'confirm_clone' && GETPOST('confirm') == 'yes') {
					break;
				}
				if (strlen($mysoc->idprof1) == 13) {
					if (isset($conf->global->CFDIXML_RESICO_125) && $conf->global->CFDIXML_RESICO_125 > 0) {
						//Get parameters
						$price_ht = GETPOST('price_ht', 'int');
						$price_ttc = GETPOST('price_ttc', 'float');
						$qty = GETPOST('qty', 'int');

						//Instance Object
						$facture = new Facture($this->db);
						$facture->fetch($object->fk_facture);
						$facture->fetch_thirdparty();

						if (strlen($facture->thirdparty->idprof1) == 12) {
							if (!empty($price_ht)) {
								$price_ht += $price_ht * (float)$conf->global->CFDIXML_RESICO_125;
								$object->subprice = number_format($price_ht, 2, '.', '');
								$object->total_ht = $object->subprice * $qty;
							}
							if (!empty($price_ttc)) {
								// Calcular price_ht a partir de price_ttc, considerando el IVA del 16%
								$price_ht = (float)$price_ttc / 1.16;
								// Incrementar el 1.25% directamente sobre price_ht y formatear el resultado
								$price_ht += $price_ht * (float)$conf->global->CFDIXML_RESICO_125;
								$object->subprice = number_format($price_ht, 2, '.', ''); // Redondeo a 2 decimales
								$object->total_ht = $object->subprice * $qty;
							}

							$object->update($user, 1);
						}
					}
				}
				break;

			// case 'LINEBILL_MODIFY':

			// 	$facture = new Facture($this->db);
			// 	$facture->fetch($object->fk_facture);
			// 	$factureline = new FactureLigne($this->db);
			// 	$factureline->fetch($object->id);
			// 	$resico = checkReceptor($facture);

			// 	if (empty($resico)) {
			// 		break;
			// 	}

			// 	$value = $this->_amount($conf->global->CFDIXML_RESICO_TAX, $object->total_ht);
			// 	$factureline->ref_ext = $value;

			// 	$this->db->begin();
			// 	$result = $factureline->update($user, 1);
			// 	if ($result > 0) {
			// 		$this->db->commit();
			// 	} else {
			// 		$this->db->rollback();
			// 	}

			// 	break;

			// case 'LINEBILL_DELETE':


			//Supplier Bill
			//case 'BILL_SUPPLIER_CREATE':
			//case 'BILL_SUPPLIER_UPDATE':
			//case 'BILL_SUPPLIER_DELETE':
			//case 'BILL_SUPPLIER_PAYED':
			//case 'BILL_SUPPLIER_UNPAYED':
			//case 'BILL_SUPPLIER_VALIDATE':
			//case 'BILL_SUPPLIER_UNVALIDATE':
			//case 'LINEBILL_SUPPLIER_CREATE':
			//case 'LINEBILL_SUPPLIER_UPDATE':
			//case 'LINEBILL_SUPPLIER_DELETE':

			// Payments
			case 'PAYMENT_CUSTOMER_CREATE':
				dol_include_once('/cfdixml/class/payment.class.php');
				require_once DOL_DOCUMENT_ROOT . '/compta/facture/class/facture.class.php';

				$payment = new Payment($this->db);
				$invoice = new Facture($this->db);
				$data = array();
				foreach ($_POST as $key => $value) {

					$id = explode('_', $key);
					$id = end($id);

					if (is_numeric($id) && !empty($value)) {
						if (strpos($key, 'amount_') !== false) {

							$eval = explode('_', $key);
							$eval = $eval[0];
							if ($eval != 'multicurrency') {
								$data[$id]['amount'] = $value;
							}
						}
						if (strpos($key, 'tc_') !== false) {
							$data[$id]['tc'] = $value;
						}
						if (strpos($key, 'multicurrency_amount_') !== false) {

							$data[$id]['multicurrency_amount'] = $value;
						}
					}
				}

				foreach ($data as $key => $value) {

					if (price2num($value['tc']) > 0) {
						$invoice->fetch($key);
						$amount = $value['amount'] ? $value['amount'] : $value['multicurrency_amount'];
						$code = $value['amount'] ? 'MX' : $invoice->multicurrency_code;
						if ($conf->currency != 'MXN') {
							$code = $value['amount'] ? $invoice->multicurrency_code : 'MXN';
						}
						$result = $payment->savePayment($object->ref, $key, $amount, $value['tc'], $code);

						if ($result < 0) {
							$error--;
						}
					}
				}

				if ($error < 0) {
					return -1;
				} else {
					return 1;
				}

				break;
			//case 'PAYMENT_SUPPLIER_CREATE':
			//case 'PAYMENT_ADD_TO_BANK':
			case 'PAYMENT_CUSTOMER_DELETE':

				dol_include_once('/cfdixml/class/payment.class.php');
				$payment = new Payment($this->db);
				$payment->deletePayment($object->ref);

				break;

			// Online
			//case 'PAYMENT_PAYBOX_OK':
			//case 'PAYMENT_PAYPAL_OK':
			//case 'PAYMENT_STRIPE_OK':

			// Donation
			//case 'DON_CREATE':
			//case 'DON_UPDATE':
			//case 'DON_DELETE':

			// Interventions
			//case 'FICHINTER_CREATE':
			//case 'FICHINTER_MODIFY':
			//case 'FICHINTER_VALIDATE':
			//case 'FICHINTER_DELETE':
			//case 'LINEFICHINTER_CREATE':
			//case 'LINEFICHINTER_UPDATE':
			//case 'LINEFICHINTER_DELETE':

			// Members
			//case 'MEMBER_CREATE':
			//case 'MEMBER_VALIDATE':
			//case 'MEMBER_SUBSCRIPTION':
			//case 'MEMBER_MODIFY':
			//case 'MEMBER_NEW_PASSWORD':
			//case 'MEMBER_RESILIATE':
			//case 'MEMBER_DELETE':

			// Categories
			//case 'CATEGORY_CREATE':
			//case 'CATEGORY_MODIFY':
			//case 'CATEGORY_DELETE':
			//case 'CATEGORY_SET_MULTILANGS':

			// Projects
			//case 'PROJECT_CREATE':
			//case 'PROJECT_MODIFY':
			//case 'PROJECT_DELETE':

			// Project tasks
			//case 'TASK_CREATE':
			//case 'TASK_MODIFY':
			//case 'TASK_DELETE':

			// Task time spent
			//case 'TASK_TIMESPENT_CREATE':
			//case 'TASK_TIMESPENT_MODIFY':
			//case 'TASK_TIMESPENT_DELETE':
			//case 'PROJECT_ADD_CONTACT':
			//case 'PROJECT_DELETE_CONTACT':
			//case 'PROJECT_DELETE_RESOURCE':

			// Shipping
			//case 'SHIPPING_CREATE':
			//case 'SHIPPING_MODIFY':
			//case 'SHIPPING_VALIDATE':
			//case 'SHIPPING_SENTBYMAIL':
			//case 'SHIPPING_BILLED':
			//case 'SHIPPING_CLOSED':
			//case 'SHIPPING_REOPEN':
			//case 'SHIPPING_DELETE':

			// and more...

			default:
				dol_syslog("Trigger '" . $this->name . "' for action '$action' launched by " . __FILE__ . ". id=" . $object->id);
				break;
		}

		return 0;
	}
}
