<?php
/**
 * Class FacturaGlobal
 */
class FactureGlobal extends CommonObject
{
	/**
	 * @var string Name of table without prefix where object is stored
	 */
	public $table_element = 'cfdixml_factura_global';

	/**
	 * @var string Name of subtable line
	 */
	public $table_element_line = 'cfdixml_factura_global_det';

	/**
	 * @var string Field with ID of parent key if this field has a parent
	 */
	public $fk_element = 'fk_factura_global';

	/**
	 * @var string String with name of icon for factura global
	 */
	public $picto = 'bill';

	/**
	 * @var array Fieldnames
	 */
	public $fields = array(
		'rowid'           => array('type'=>'integer', 'label'=>'ID', 'enabled'=>1, 'position'=>1, 'notnull'=>1, 'visible'=>0, 'noteditable'=>'1', 'index'=>1, 'comment'=>"Id"),
		'ref'             => array('type'=>'varchar(30)', 'label'=>'Ref', 'enabled'=>1, 'position'=>10, 'notnull'=>1, 'visible'=>1, 'index'=>1),
		'fk_soc'          => array('type'=>'integer', 'label'=>'ThirdParty', 'enabled'=>1, 'position'=>20, 'notnull'=>1, 'visible'=>1),
		'periodo_inicio'  => array('type'=>'date', 'label'=>'StartPeriod', 'enabled'=>1, 'position'=>30, 'notnull'=>1, 'visible'=>1),
		'periodo_fin'     => array('type'=>'date', 'label'=>'EndPeriod', 'enabled'=>1, 'position'=>40, 'notnull'=>1, 'visible'=>1),
		'forma_pago'      => array('type'=>'varchar(10)', 'label'=>'PaymentMode', 'enabled'=>1, 'position'=>50, 'notnull'=>1, 'visible'=>1),
		'metodo_pago'     => array('type'=>'varchar(3)', 'label'=>'PaymentMethod', 'enabled'=>1, 'position'=>60, 'notnull'=>1, 'visible'=>1),
		'total_ht'        => array('type'=>'double(24,8)', 'label'=>'Subtotal', 'enabled'=>1, 'position'=>70, 'notnull'=>0, 'visible'=>1),
		'total_tva'       => array('type'=>'double(24,8)', 'label'=>'VAT', 'enabled'=>1, 'position'=>80, 'notnull'=>0, 'visible'=>1),
		'total_ttc'       => array('type'=>'double(24,8)', 'label'=>'Total', 'enabled'=>1, 'position'=>90, 'notnull'=>0, 'visible'=>1),
		'date_creation'   => array('type'=>'datetime', 'label'=>'DateCreation', 'enabled'=>1, 'position'=>100, 'notnull'=>1, 'visible'=>0),
		'tms'             => array('type'=>'timestamp', 'label'=>'DateModification', 'enabled'=>1, 'position'=>110, 'notnull'=>0, 'visible'=>0),
		'fk_user_create'  => array('type'=>'integer', 'label'=>'UserCreate', 'enabled'=>1, 'position'=>120, 'notnull'=>1, 'visible'=>0),
		'fk_user_modif'   => array('type'=>'integer', 'label'=>'UserModif', 'enabled'=>1, 'position'=>130, 'notnull'=>0, 'visible'=>0),
		'status'          => array('type'=>'smallint', 'label'=>'Status', 'enabled'=>1, 'position'=>140, 'notnull'=>0, 'visible'=>1),
		'uuid'            => array('type'=>'varchar(36)', 'label'=>'UUID', 'enabled'=>1, 'position'=>150, 'notnull'=>0, 'visible'=>1),
		'entity'          => array('type'=>'integer', 'label'=>'Entity', 'default'=>1, 'enabled'=>1, 'position'=>160, 'notnull'=>1, 'visible'=>0)
	);

	public $rowid;
	public $ref;
	public $fk_soc;
	public $periodo_inicio;
	public $periodo_fin;
	public $forma_pago;
	public $metodo_pago;
	public $total_ht;
	public $total_tva;
	public $total_ttc;
	public $date_creation;
	public $tms;
	public $fk_user_create;
	public $fk_user_modif;
	public $status;
	public $uuid;
	public $entity;

	const STATUS_DRAFT = 0;
	const STATUS_VALIDATED = 1;
	const STATUS_STAMPED = 2;
	const STATUS_CANCELED = 9;

	/**
	 * Constructor
	 *
	 * @param DoliDB $db Database handler
	 */
	public function __construct($db)
	{
		$this->db = $db;
	}

	/**
	 * Create object into database
	 *
	 * @param  User $user      User that creates
	 * @param  bool $notrigger false=launch triggers after, true=disable triggers
	 * @return int             <0 if KO, Id of created object if OK
	 */
	public function create(User $user, $notrigger = false)
	{
		$this->date_creation = dol_now();
		$this->fk_user_create = $user->id;

		return $this->createCommon($user, $notrigger);
	}

	/**
	 * Load object in memory from the database
	 *
	 * @param int    $id   Id object
	 * @param string $ref  Ref
	 * @return int         <0 if KO, 0 if not found, >0 if OK
	 */
	public function fetch($id, $ref = null)
	{
		$result = $this->fetchCommon($id, $ref);
		return $result;
	}

	/**
	 * Update object into database
	 *
	 * @param  User $user      User that modifies
	 * @param  bool $notrigger false=launch triggers after, true=disable triggers
	 * @return int             <0 if KO, >0 if OK
	 */
	public function update(User $user, $notrigger = false)
	{
		$this->fk_user_modif = $user->id;
		return $this->updateCommon($user, $notrigger);
	}

	/**
	 * Delete object in database
	 *
	 * @param  User $user      User that deletes
	 * @param  bool $notrigger false=launch triggers after, true=disable triggers
	 * @return int             <0 if KO, >0 if OK
	 */
	public function delete(User $user, $notrigger = false)
	{
		return $this->deleteCommon($user, $notrigger);
	}
}
