<?php
/* Copyright (C) 2022 SuperAdmin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

/**
 * \file    cfdixml/class/cfdixml.class.php
 * \ingroup cfdixml
 * \brief   Example hook overload.
 *
 * Put detailed description here.
 */
dol_include_once('/cfdixml/vendor/autoload.php');
dol_include_once('/cfdixml/lib/cfdixml.lib.php');
dol_include_once('/cfdixml/class/cfdi.class.php');
dol_include_once('/cfdixml/class/cfdiutils.class.php');
require_once DOL_DOCUMENT_ROOT . '/compta/facture/class/facture.class.php';
require_once DOL_DOCUMENT_ROOT . '/compta/paiement/class/paiement.class.php';
require_once DOL_DOCUMENT_ROOT . '/societe/class/societe.class.php';
require_once DOL_DOCUMENT_ROOT . '/core/class/extrafields.class.php';

// use \CfdiUtils\Elements\Pagos20;
use \CfdiUtils\Elements\Pagos20\Pagos;
use \CfdiUtils\CfdiCreator40;
use \CfdiUtils\TimbreFiscalDigital\TfdCadenaDeOrigen;
use \PhpCfdi\Credentials\PrivateKey;

/**
 * Class Cfdixml
 */

class Cfdixml extends CfdiUtils
{

	public $db;
	// const CANCEL_INVOICE = 'cancel_invoice';
	public $output;
	public $error;

	public function __construct($db)
	{

		$this->db = $db;
	}

	// Type
	// stamp_invoice
	// cancel_invoice //
	// cancel_invoice_r //reason
	// cancel_payment
	// stamp_payment

	public function insert_queue($id, $type, $reason = null)
	{

		$sql = "INSERT INTO " . MAIN_DB_PREFIX . "cfdixml_queue (";
		$sql .= "fk_object,";
		$sql .= "type,";
		$sql .= "reason";
		$sql .= ") VALUES (";
		$sql .= $id . ",";
		$sql .= $reason ? "'" . $type . "'," : "'" . $type . "'";
		$sql .= $reason ? $reason : null;
		$sql .= ")";
		$resql = $this->db->query($sql);
	}

	public function queue()
	{
		global $user, $conf;

		$this->output = '';
		$this->error = '';

		$error = 0;

		$sql = " SELECT fk_object as id, type, reason  FROM " . MAIN_DB_PREFIX . "cfdixml_queue";
		$sql .= " WHERE active = 1";

		$resql = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);
			if ($num > 0) {
				$i = 0;
				while ($i < $num) {
					$obj =  $this->db->fetch_object($resql);

					switch ($obj->type) {

						case "cancel_invoice":
							//Facturalo
							$object = new Facture($this->db);
							$object->fetch($obj->id);
							if ($conf->global->CFDIXML_WS_MODE == 'TEST') $url = $conf->global->CFDIXML_WS_TEST;
							if ($conf->global->CFDIXML_WS_MODE == 'PRODUCTION') $url = $conf->global->CFDIXML_WS_PRODUCTION;
							$conexion = null;
							$conexion = new Conexion($url);

							$societe = new Societe($this->db);
							$societe->fetch($object->socid);

							$emisor =  getEmisor();
							$receptor  = getReceptor($object, $societe);
							$cerfile = file_get_contents($conf->global->CFDIXML_CER_FILE);
							$keyfile = file_get_contents($conf->global->CFDIXML_KEY_FILE);

							$xmlcanceled = $conexion->operacion_cancelar2(
								$conf->global->CFDIXML_WS_TOKEN,
								base64_encode($keyfile),
								base64_encode($cerfile),
								$conf->global->CFDIXML_CERKEY_PASS,
								$object->array_options['options_cfdixml_UUID'],
								$emisor['Rfc'],
								$receptor['Rfc'],
								$object->total_ttc,
								'0' . $obj->reason //provisional
							);

							$xmlcanceled = json_decode($xmlcanceled);

							if ($xmlcanceled->resultado == 'success') {
								// echo '<pre>';print_r(json_decode($xmlcanceled));exit;
								// exit;
								$filedir = $conf->facture->multidir_output[$object->entity] . '/' . dol_sanitizeFileName($object->ref);

								$file_xml = fopen($filedir . "/ACUSE_CANCELACION_" . $object->ref . '_' . $object->array_options['options_cfdixml_UUID'] . ".xml", "w");
								fwrite($file_xml, utf8_encode($xmlcanceled->acuse));
								fclose($file_xml);

								//Provisional FIX
								$fecha_emision = date('Y-m-d H:i:s');
								$fecha_emision = str_replace(" ", "T", $fecha_emision);
								$sql = "UPDATE " . MAIN_DB_PREFIX . "facture_extrafields ";
								$sql .= " SET cfdixml_fechacancelacion = '" . $fecha_emision . "'";
								$xmlcanceled->codigo ? $sql .= ", cfdixml_codigocancelacion = '" . $xmlcanceled->codigo . "'" : null;
								$sql .= ", cfdixml_xml_cancel = \"" . base64_encode($xmlcanceled->acuse) . "\"";
								$sql .= " WHERE fk_object = " . $object->id;



								$invoice = new Facture($this->db);
								$invoice->fetch($object->id);

								$result = $invoice->setCanceled($user, 'cfdi_cancel', 'Factura cancelada ante el sat');
								if ($result > 0) {
									dol_syslog("Factura " . $object->ref . " con UUID " . $object->array_options['options_cfdixml_UUID'] . ' cancelada con éxico');
									$update = "UPDATE " . MAIN_DB_PREFIX . "cfdixml_queue";
									$update .= " SET active = 0 WHERE fk_object = " . $obj->id;
									$this->db->query($update);
								}
							} else {
								dol_syslog("Factura " . $object->ref . " con UUID " . $object->array_options['options_cfdixml_UUID'] . ' ERROR ' . $xmlcanceled->codigo . ': ' . $xmlcanceled->mensaje);

								$update = "UPDATE " . MAIN_DB_PREFIX . "cfdixml_queue";
								$update .= " SET note = '" . $xmlcanceled->codigo . ": " . $xmlcanceled->mensaje . "'";
								$update .= " WHERE fk_object = " . $obj->id;
								$this->db->query($update);
								$error++;
							}

							break;
					}
					$i++;
				}
			}
		}

		if ($error > 0) {
			$this->output = "quedaron elementos por procesar";
			return 0;
		} else {
			$this->error = "todos los elementos procesados";
			return $error;
		}
	}

	public function preCfdiPago($idPayment, $cer, $keyfile, $passkey)
	{
		global $conf;

		$payment = new Payment($this->db);
		$societe = new Societe($this->db);
		$facture = new Facture($this->db);
		$paiement = new Paiement($this->db);
		$extrafields = new ExtraFields($this->db);


		$payment->fetch($idPayment);
		$lines = $payment->fetchLines();
		$societe->fetch($payment->fk_soc);
		$facture->fetch($this->getInvoiceId($lines[0]->fk_paiement_facture));

		$emisor = getEmisor();
		$arrsf = explode('-', $payment->ref);
		$serie = $arrsf[0];
		$folio = $arrsf[1];
		// Crear un objeto DateTime
		$fecha = new DateTime();

		// Establecer el timestamp
		$fecha->setTimestamp($payment->date_creation);

		// Formatear la fecha para incluir la 'T' entre la fecha y la hora
		$fechaIso8601 = $fecha->format('Y-m-d\TH:i:s');
		// echo '<pre>';
		// print_r($conf->global->MAIN_INFO_SOCIETE_ZIP);
		// echo '</pre>';

		$sql = "SELECT ROUND(sum(amount),4) as totalpago FROM " . MAIN_DB_PREFIX . "cfdixml_payment_lines WHERE fk_payment = " . $idPayment;

		$resql = $this->db->query($sql);
		$obj = $this->db->fetch_object($resql);
		//Total monto del pago
		// echo $obj->totalpago;

		$receptor = getReceptor($facture, $societe);
		$receptor['UsoCFDI'] = 'CP01';
		$certificado = new \CfdiUtils\Certificado\Certificado($cer);

		$creator = new CfdiCreator40([
			"Fecha" =>  date('Y-m-d') . 'T' . date('H:i:s'),
			"Moneda" => "XXX",
			"SubTotal" => 0,
			"Total" => 0,
			"TipoDeComprobante" => "P",
			"LugarExpedicion" => $conf->global->MAIN_INFO_SOCIETE_ZIP,
			"Version" => "4.0",
			"Exportacion" => "01"

		], $certificado);

		$cfdi = $creator->comprobante();

		$cfdi->addEmisor($emisor);
		// var_dump($receptor);exit;
		$cfdi->addReceptor($receptor);

		$cfdi->addConcepto([
			'Descripcion'   => "Pago",
			'Cantidad'      => 1,
			'ValorUnitario' => 0,
			'Importe'       => 0,
			'ClaveUnidad'   => "ACT",
			'ClaveProdServ' => "84111506",
			'ObjetoImp'     => "01"
		]);
		$complementoPago = new Pagos();
		$cfdipago = $complementoPago->addPago(
			[
				'FechaPago' => $fechaIso8601,
				'FormaDePagoP' => '03', //provisional
				'Monto' => number_format($obj->totalpago, 2, '.', ''),
				'MonedaP' => "MXN", //provisional
				'TipoCambioP' => 1
			]

		);
		// Calcular la suma total de los pagos documentados
		$sumaDocumentos = 0;
		$BaseP = 0;
		$ImporteP = 0;
		foreach ($lines as $key => $value) {

			$paiement->fetch($value->fk_paiement);
			$facture->fetch($value->fk_paiement_facture);
			$array_pago = getPayments($paiement);
			$data_arra_pagos = $this->get_payments_data($paiement->ref);

			foreach ($array_pago as $tmppago) {


				$documentosPago = $tmppago['pago']['DoctoRelacionado'];
				$traslados =  $tmppago['pago']['Impuestosp']['Traslados'][0];

				$totalPago = 0;
				foreach ($documentosPago as $pago) {

					$equivalencia = $data_arra_pagos[$paiement->ref];
					if (!is_null($equivalencia)) {
						if ($equivalencia['fk_facture'] == $facture->id) {

							$equivalenciaDR = number_format($facture->multicurrency_tx, 10, '.', '');
							$BaseP += (float)$traslados["BaseP"] / $equivalenciaDR;
							$ImporteP += (float)$traslados["ImporteP"] / $equivalenciaDR;
						}
					} else {
						$equivalenciaDR = 1;
						$BaseP += (float)$traslados["BaseP"];
						$ImporteP += (float)$traslados["ImporteP"];
					}
					// echo $BaseP.'<br>';
					$totalPago += number_format($BaseP, 10, '.', '') + number_format($ImporteP, 10, '.', '');

					$impSaldoAnt = $pago["ImpSaldoAnt"];
					$impPagado = $pago["ImpPagado"];
					$impSaldoInsoluto = $pago["ImpSaldoInsoluto"];

					if ($pago["MonedaDR"] == "MXN") {
						$impSaldoAnt = number_format((float)$impSaldoAnt, 2, '.', '');
						$impPagado = number_format((float)$impPagado, 2, '.', '');
						$impSaldoInsoluto = number_format((float)$impSaldoInsoluto, 2, '.', '');
					}

					$doctoRelacionado = $cfdipago->addDoctoRelacionado(
						[
							'IdDocumento'       => $pago["IdDocumento"],
							'MonedaDR'          => $pago["MonedaDR"],
							'NumParcialidad'    => $pago["NumParcialidad"],
							'ImpSaldoAnt'       => $impSaldoAnt,
							'ImpPagado'         => $impPagado,
							'ImpSaldoInsoluto'  => $impSaldoInsoluto,
							'EquivalenciaDR'    => $equivalenciaDR,
							'ObjetoImpDR'       => "02"
						]
					);
					$sumaDocumentos += (float)
					$impuestoDR = $pago["ImpuestosDR"][0];

					$doctoRelacionado->addImpuestosDR()->addTrasladosDR()->addTrasladoDR($impuestoDR);
				}
			}
		}

		$cfdipago->addImpuestosP()->addTrasladosP()->addTrasladoP([

			'BaseP' =>  number_format(($BaseP + $ImporteP) - $ImporteP, 6, '.', ''),
			'ImporteP' => number_format($ImporteP, 6, '.', ''),
			'ImpuestoP' => "002",
			'TasaOCuotaP' => "0.160000",
			'TipoFactorP' => "Tasa",
		]);
		// echo $ImporteP;exit;
		$iva_rate = 0.16;
		$BaseP = $obj->totalpago / (1 + $iva_rate);
		$ImporteP = $BaseP * $iva_rate;

		$complementoPago->addTotales([
			'MontoTotalPagos' => number_format($obj->totalpago, 2, '.', ''),
			'TotalTrasladosBaseIVA16' => number_format($BaseP, 2, '.', ''),
			'TotalTrasladosImpuestoIVA16' => number_format($ImporteP, 2, '.', ''),
		]);

		$cfdi->addComplemento($complementoPago);
		$creator->addSumasConceptos(null, 0);
		$pemPrivateKeyContents = PrivateKey::convertDerToPem(file_get_contents('file://' . $keyfile), $passkey !== '');

		// método de ayuda para generar el sello (obtener la cadena de origen y firmar con la llave privada)
		$creator->addSello($pemPrivateKeyContents, $passkey);

		// // método de ayuda para mover las declaraciones de espacios de nombre al nodo raíz
		$creator->moveSatDefinitionsToComprobante();

		// // método de ayuda para validar usando las validaciones estándar de creación de la librería
		$asserts = $creator->validate();
		$asserts->hasErrors(); // contiene si hay o no errores
		$xml = $creator->asXml();

		if (!file_exists($conf->cfdixml->multidir_output[$conf->entity] . '/payment/' . dol_sanitizeFileName($payment->ref) . "/" . $payment->ref . ".xml")) {
			mkdir($conf->cfdixml->multidir_output[$conf->entity] . '/payment/' . dol_sanitizeFileName($payment->ref), 0755, true);
		}
		$filedir = $conf->cfdixml->multidir_output[$conf->entity] . '/payment/' . dol_sanitizeFileName($payment->ref);
		// echo $filedir;exit;
		$file_xml = fopen($filedir . "/" . $payment->ref . ".xml", "w");
		fwrite($file_xml, mb_convert_encoding($xml, 'UTF-8'));
		fclose($file_xml);

		/* Finkok */
		$xml = $this->quickStamp($xml, $conf->global->CFDIXML_WS_TOKEN, $conf->global->CFDIXML_WS_MODE);
		if (!file_exists($conf->cfdixml->multidir_output[$conf->entity] . '/payment/' . dol_sanitizeFileName($payment->ref) . "/" . $payment->ref . ".xml")) {
			mkdir($conf->cfdixml->multidir_output[$conf->entity] . '/payment/' . dol_sanitizeFileName($payment->ref), 0755, true);
		}
		if ($xml['code'] == 200) {
			// crear el objeto CFDI
			$cfdi = \CfdiUtils\Cfdi::newFromString($xml['data']);
			// obtener el QuickReader con el método dedicado
			$comprobante = $cfdi->getQuickReader();
			// echo '<pre>';print_r($comprobante->complemento->timbreFiscalDigital['UUID']);exit;
			$file_xml = fopen($filedir . "/" . $payment->ref . '_' . $comprobante->complemento->timbreFiscalDigital['UUID'] . ".xml", "w");
			fwrite($file_xml, mb_convert_encoding($xml['data'], 'utf8'));

			$uuid =  $comprobante->complemento->timbreFiscalDigital['UUID'];
			// clean cfdi
			$xml = \PhpCfdi\CfdiCleaner\Cleaner::staticClean($xml['data']);

			// create the main node structure
			$comprobante = \CfdiUtils\Nodes\XmlNodeUtils::nodeFromXmlString($xml);

			// create the CfdiData object, it contains all the required information
			$cfdiData = (new \PhpCfdi\CfdiToPdf\CfdiDataBuilder())
				->build($comprobante);

			// create the converter
			$converter = new \PhpCfdi\CfdiToPdf\Converter(
				new \PhpCfdi\CfdiToPdf\Builders\Html2PdfBuilder()
			);

			// create the invoice as output.pdf
			$converter->createPdfAs($cfdiData, $filedir . "/" . $payment->ref . '_' . $uuid . ".pdf");

			return ['code' => 200, 'data' => $this->getData($xml)];
		} else {
			return $xml;
		}
	}

	public function getInvoiceId($fk_paiement_facture)
	{

		$sql = " SELECT fk_facture FROM " . MAIN_DB_PREFIX . "paiement_facture WHERE rowid = " . $fk_paiement_facture;
		$resql = $this->db->query($sql);
		if ($resql) {
			$num = $this->db->num_rows($resql);
			if ($num > 0) {
				$i = 0;
				while ($i < $num) {
					$obj =  $this->db->fetch_object($resql);
					$id = $obj->fk_facture;
					$i++;
				}
			}
		}
		return $id;
	}



	public function get_payments_data($ref)
	{
		$sql = "SELECT ref_payment, fk_facture, amount, tx, code FROM " . MAIN_DB_PREFIX . "cfdixml_payment_invoice";
		$sql .= " WHERE ref_payment = '" . $ref . "'";

		$resql = $this->db->query($sql);

		$pay_arr = array();
		if ($resql) {
			$num = $this->db->num_rows($resql);
			if ($num > 0) {
				$i = 0;
				while ($i < $num) {
					$obj = $this->db->fetch_object($resql);
					$pay_arr[$obj->ref_payment] = [
						'fk_facture' => $obj->fk_facture,
						'amount' => $obj->amount,
						'tx' => $obj->tx,
						'code' => $obj->code
					];

					$i++;
				}
			}
		}
		return $pay_arr;
	}

	public function getData($xml)
	{
		// clean cfdi

		$cfdi = \CfdiUtils\Cfdi::newFromString($xml);
		$cfdi->getVersion(); // (string) 3.3
		$cfdi->getDocument(); // clon del objeto DOMDocument
		$cfdi->getSource(); // (string) <cfdi:Comprobante...
		$comprobante = $cfdi->getNode(); // Nodo de trabajo del nodo cfdi:Comprobante
		$tfd = $comprobante->searchNode('cfdi:Complemento', 'tfd:TimbreFiscalDigital');
		$emisor = $comprobante->searchNode('cfdi:Emisor');
		$receptor = $comprobante->searchNode('cfdi:Receptor');
		$tfdXmlString = \CfdiUtils\Nodes\XmlNodeUtils::nodeToXmlString($tfd);
		$builder = new TfdCadenaDeOrigen();
		$tfdCaenaOrigen = $builder->build($tfdXmlString);

		$data = [
			'SelloCFD'    => $tfd['SelloCFD'],
			'SelloSAT'    => $tfd['SelloSAT'],
			'CertCFD'    => $comprobante['NoCertificado'],
			'FechaTimbrado' => $tfd['FechaTimbrado'],
			'FechaEmision' => $comprobante['Fecha'],
			'UUID' => $tfd['UUID'],
			'CertSAT' => $tfd['NoCertificadoSAT'],
			'CadenaOriginal' => $tfdCaenaOrigen,
			'EmisorRfc' =>  $emisor['Rfc'],
			'ReceptorRfc' =>  $receptor['Rfc'],
			'Total' => $comprobante['Total'],
		];

		return $data;
	}
}
