<?php

require_once DOL_DOCUMENT_ROOT . '/core/class/commonobject.class.php';

class CfdiFactureCce extends CommonObject
{
	public $table_element = 'cfdixml_facture_cce';
	public $element = 'cfdixml_facture_cce';

	public $fk_object;
	public $version;
	public $motivo_traslado;
	public $clave_pedimento;
	public $certificado_origen;
	public $num_certificado_origen;
	public $numero_exportador_confiable;
	public $incoterm;
	public $observaciones;
	public $tipo_cambio_usd;
	public $total_usd;

	public $fields = array(
		'rowid' => array('type' => 'integer', 'label' => 'TechnicalID', 'enabled' => 1, 'visible' => -1, 'notnull' => 1, 'position' => 1),
		'fk_object' => array('type' => 'integer', 'label' => 'Invoice', 'enabled' => 1, 'visible' => -1, 'notnull' => 1, 'position' => 10, 'index' => 1),
		'version' => array('type' => 'varchar(10)', 'label' => 'Version', 'enabled' => 1, 'visible' => -1, 'default' => '2.0', 'position' => 20),
		'motivo_traslado' => array('type' => 'varchar(50)', 'label' => 'MotivoTraslado', 'enabled' => 1, 'visible' => -1, 'position' => 30),
		'clave_pedimento' => array('type' => 'varchar(50)', 'label' => 'ClavePedimento', 'enabled' => 1, 'visible' => -1, 'position' => 40),
		'certificado_origen' => array('type' => 'tinyint(1)', 'label' => 'CertificadoOrigen', 'enabled' => 1, 'visible' => -1, 'default' => 0, 'position' => 50),
		'num_certificado_origen' => array('type' => 'varchar(40)', 'label' => 'NumCertificadoOrigen', 'enabled' => 1, 'visible' => -1, 'position' => 60),
		'numero_exportador_confiable' => array('type' => 'varchar(50)', 'label' => 'NumExportadorConfiable', 'enabled' => 1, 'visible' => -1, 'position' => 70),
		'incoterm' => array('type' => 'varchar(20)', 'label' => 'Incoterm', 'enabled' => 1, 'visible' => -1, 'position' => 80),
		'observaciones' => array('type' => 'varchar(300)', 'label' => 'Observaciones', 'enabled' => 1, 'visible' => -1, 'position' => 90),
		'tipo_cambio_usd' => array('type' => 'double(10,4)', 'label' => 'TipoCambioUSD', 'enabled' => 1, 'visible' => -1, 'position' => 100),
		'total_usd' => array('type' => 'double(10,2)', 'label' => 'TotalUSD', 'enabled' => 1, 'visible' => -1, 'position' => 110)
	);

	public function __construct($db)
	{
		$this->db = $db;
	}

	public function create($user)
	{
		$sql = "SELECT count(*) as nb FROM ". MAIN_DB_PREFIX. $this->table_element. " WHERE fk_object = ". $this->db->escape($this->fk_object);
		$res = $this->db->query($sql);
		$obj = $this->db->fetch_object($res);
		if($obj->nb > 0) {
			$sql = "SELECT rowid FROM ". MAIN_DB_PREFIX. $this->table_element. " WHERE fk_object = ". $this->db->escape($this->fk_object);
			$res = $this->db->query($sql);
			$obj = $this->db->fetch_object($res);
			$this->id = $obj->rowid;
			return $this->update($user,1);
		} else {
			$sql = "INSERT INTO " . MAIN_DB_PREFIX . $this->table_element . " (";
			$values = array();
			$columns = array();

			foreach ($this->fields as $key => $field) {
				if ($key == 'rowid') continue;
				if (isset($this->$key)) {
					$columns[] = $key;

					if (strpos($field['type'], 'integer') !== false) {
						$values[] = (int)$this->$key;
					} elseif (strpos($field['type'], 'double') !== false || strpos($field['type'], 'float') !== false) {
						$values[] = (float)$this->$key;
					} else {
						$values[] = "'" . $this->db->escape($this->$key) . "'";
					}
				}
			}

			$sql .= implode(',', $columns) . ") VALUES (" . implode(',', $values) . ")";

			$res = $this->db->query($sql);
			if ($res) {
				$this->id = $this->db->last_insert_id(MAIN_DB_PREFIX . $this->table_element);
				return $this->id;
			}
		}
		return -1;
	}

	public function fetch($id, $fk_object = 0)
	{
		$sql = "SELECT ";
		$sql .= "rowid,";
		$sql .= "fk_object,";
		$sql .= "version,";
		$sql .= "motivo_traslado,";
		$sql .= "clave_pedimento,";
		$sql .= "certificado_origen,";
		$sql .= "num_certificado_origen,";
		$sql .= "numero_exportador_confiable,";
		$sql .= "incoterm,";
		$sql .= "observaciones,";
		$sql .= "tipo_cambio_usd,";
		$sql .= "total_usd";
		if ($fk_object > 0) {
			$sql .= " FROM " . MAIN_DB_PREFIX . $this->table_element . " WHERE fk_object = " . (int)$fk_object;
		} else {
			$sql .= "FROM " . MAIN_DB_PREFIX . $this->table_element . " WHERE rowid = " . (int)$id;
		}
		$resql = $this->db->query($sql);
		if ($resql) {
			$obj = $this->db->fetch_object($resql);
			if ($obj) {
				foreach ($this->fields as $key => $field) {
					$this->$key = $obj->$key;
				}
				return 1;
			}
		}
		return -1;
	}

	public function update($user, $notrigger = 0)
	{
		$sql = "UPDATE " . MAIN_DB_PREFIX . $this->table_element . " SET ";
		$updates = array();

		foreach ($this->fields as $key => $field) {
			if ($key == 'rowid') continue;
			if (isset($this->$key)) {
				if (strpos($field['type'], 'integer') !== false) {
					$updates[] = $key . " = " . (int)$this->$key;
				} elseif (strpos($field['type'], 'double') !== false || strpos($field['type'], 'float') !== false) {
					$updates[] = $key . " = " . (float)$this->$key;
				} elseif (strpos($field['type'], 'varchar') !== false) {
					$updates[] = $key . " = '" . $this->db->escape($this->$key) . "'";
				}
			}
		}

		$sql .= implode(', ', $updates);
		$sql .= " WHERE rowid = " . (int)$this->id;

		$this->db->begin();
		$res = $this->db->query($sql);
		if ($res) {
			$this->db->commit();
			return 1;
		} else {
			$this->db->rollback();
			dol_syslog("Error updating " . get_class($this) . ": " . $this->db->last_error());
			return -1;
		}
	}

	public function delete($id)
	{
		$sql = "DELETE FROM " . MAIN_DB_PREFIX . $this->table_element . " WHERE rowid = " . (int)$id;
		$res = $this->db->query($sql);
		if ($res) {
			return 1;
		}
		return -1;
	}

}

class CfdiFactureDetCce extends CommonObject
{
	public $table_element = 'cfdixml_facturedet_cce';
	public $element = 'cfdixml_facturedet_cce';

	public $fk_object;
	public $fk_facturedet;
	public $no_identificacion;
	public $fraccion_arancelaria;
	public $cantidad_aduana;
	public $unidad_aduana;
	public $valor_unitario_aduana;
	public $valor_dolares;

	public $fields = array(
		'rowid' => array('type' => 'integer', 'label' => 'TechnicalID', 'enabled' => 1, 'visible' => -1, 'notnull' => 1, 'position' => 1),
		'fk_object' => array('type' => 'integer', 'label' => 'Invoice', 'enabled' => 1, 'visible' => -1, 'notnull' => 1, 'position' => 10, 'index' => 1),
		'fk_facturedet' => array('type' => 'integer', 'label' => 'InvoiceLine', 'enabled' => 1, 'visible' => -1, 'notnull' => 1, 'position' => 20, 'index' => 1),
		'no_identificacion' => array('type' => 'varchar(100)', 'label' => 'NoIdentificacion', 'enabled' => 1, 'visible' => -1, 'position' => 30),
		'fraccion_arancelaria' => array('type' => 'varchar(20)', 'label' => 'FraccionArancelaria', 'enabled' => 1, 'visible' => -1, 'position' => 40),
		'cantidad_aduana' => array('type' => 'double(16,3)', 'label' => 'CantidadAduana', 'enabled' => 1, 'visible' => -1, 'position' => 50),
		'unidad_aduana' => array('type' => 'varchar(50)', 'label' => 'UnidadAduana', 'enabled' => 1, 'visible' => -1, 'position' => 60),
		'valor_unitario_aduana' => array('type' => 'double(16,6)', 'label' => 'ValorUnitarioAduana', 'enabled' => 1, 'visible' => -1, 'position' => 70),
		'valor_dolares' => array('type' => 'double(16,4)', 'label' => 'ValorDolares', 'enabled' => 1, 'visible' => -1, 'position' => 80)
	);

	public function __construct($db)
	{
		$this->db = $db;
	}

	public function create($user)
	{
		$sql = "INSERT INTO " . MAIN_DB_PREFIX . $this->table_element . " (";
		$values = array();
		$columns = array();

		foreach ($this->fields as $key => $field) {
			if ($key == 'rowid') continue;
			if (isset($this->$key)) {
				$columns[] = $key;

				if (strpos($field['type'], 'integer') !== false) {
					$values[] = (int)$this->$key;
				} elseif (strpos($field['type'], 'double') !== false || strpos($field['type'], 'float') !== false) {
					$values[] = (float)$this->$key;
				} else {
					$values[] = "'" . $this->db->escape($this->$key) . "'";
				}
			}
		}

		$sql .= implode(',', $columns) . ") VALUES (" . implode(',', $values) . ")";

		$res = $this->db->query($sql);
		if ($res) {
			$this->id = $this->db->last_insert_id(MAIN_DB_PREFIX . $this->table_element);
			return $this->id;
		}
		return -1;
	}

	public function fetch($id, $fk_object = 0)
	{
		$sql = "SELECT ";
		$sql .= "rowid,";
		$sql .= "fk_object,";
		$sql .= "version,";
		$sql .= "motivo_traslado,";
		$sql .= "clave_pedimento,";
		$sql .= "certificado_origen,";
		$sql .= "num_certificado_origen,";
		$sql .= "numero_exportador_confiable,";
		$sql .= "incoterm,";
		$sql .= "observaciones,";
		$sql .= "tipo_cambio_usd,";
		$sql .= "total_usd";
		if ($fk_object > 0) {
			$sql .= " FROM " . MAIN_DB_PREFIX . $this->table_element . " WHERE fk_object = " . (int)$fk_object;
		} else {
			$sql .= "FROM " . MAIN_DB_PREFIX . $this->table_element . " WHERE rowid = " . (int)$id;
		}
		$resql = $this->db->query($sql);
		if ($resql) {
			$obj = $this->db->fetch_object($resql);
			if ($obj) {
				foreach ($this->fields as $key => $field) {
					$this->$key = $obj->$key;
				}
				return 1;
			}
		}
		return -1;
	}

	public function update($user, $notrigger = 0)
	{
		$sql = "UPDATE " . MAIN_DB_PREFIX . $this->table_element . " SET ";
		$updates = array();

		foreach ($this->fields as $key => $field) {
			if ($key == 'rowid') continue;
			if (isset($this->$key)) {
				if (strpos($field['type'], 'integer') !== false) {
					$updates[] = $key . " = " . (int)$this->$key;
				} elseif (strpos($field['type'], 'double') !== false || strpos($field['type'], 'float') !== false) {
					$updates[] = $key . " = " . (float)$this->$key;
				} elseif (strpos($field['type'], 'varchar') !== false) {
					$updates[] = $key . " = '" . $this->db->escape($this->$key) . "'";
				}
			}
		}

		$sql .= implode(', ', $updates);
		$sql .= " WHERE rowid = " . (int)$this->id;

		$this->db->begin();
		$res = $this->db->query($sql);
		if ($res) {
			$this->db->commit();
			return 1;
		} else {
			$this->db->rollback();
			dol_syslog("Error updating " . get_class($this) . ": " . $this->db->last_error());
			return -1;
		}
	}

	public function delete($id)
	{
		$sql = "DELETE FROM " . MAIN_DB_PREFIX . $this->table_element . " WHERE rowid = " . (int)$id;
		$res = $this->db->query($sql);
		if ($res) {
			return 1;
		}
		return -1;
	}
}
