<?php

require_once DOL_DOCUMENT_ROOT . "/custom/cfdixml/vendor/autoload.php";

use CfdiUtils\CfdiCreator40;
use CfdiUtils\Certificado\Certificado;
use CfdiUtils\Elements\Pagos20\Pagos;

class Cfdi
{
    private $creator;
	private $pagosComplemento;
    public function __construct($pathCertificado,$comprobanteAtributos)
    {

        $certificado = new \CfdiUtils\Certificado\Certificado($pathCertificado);;
        $this->creator = new CfdiCreator40($comprobanteAtributos, $certificado);

		// Crea el complemento de pagos y lo añade al comprobante
		$this->pagosComplemento = new Pagos();
		$this->creator->comprobante()->addComplemento($this->pagosComplemento);
		$this->creator->addSumasConceptos(null, 0);

    }

    public function addEmisor($attributes)
    {
        $this->creator->comprobante()->addEmisor($attributes);
    }

    public function addReceptor($attributes)
    {
        $this->creator->comprobante()->addReceptor($attributes);
    }

    public function addConcepto($attributes)
    {
        $this->creator->comprobante()->addConcepto($attributes);
    }

    public function addPago(array $attributes)
    {
        // Añade un pago al complemento de pagos
        return $this->pagosComplemento->addPago($attributes);
    }

    public function addDoctoRelacionado($pago, $attributes)
    {
        return $pago->addDoctoRelacionado($attributes);
    }

	public function addImpuestoDR($doctoRelacionado, $attributes){

		$doctoRelacionado->addImpuestosDR();
		$doctoRelacionado->getTrasladosDR->addTrasladoDR($attributes);

	}
	public function addTotales(){
		$this->pagosComplemento->addTotales();
	}

	public function addTrasladoPago($pago, $attributes){
		$trasladosPago = $pago->addImpuestosP();
		$trasladosPago->getTrasladosP()->addTrasladoP($attributes);
	}

    public function getXML($file,$password)
    {

        $this->creator->addSello("file://{$file}", $password);
        return $this->creator->asXml();
    }
}


