<?php
/* Copyright (C) 2022 SuperAdmin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

/**
 * \file    cfdixml/class/actions_cfdixml.class.php
 * \ingroup cfdixml
 * \brief   Example hook overload.
 *
 * Put detailed description here.
 */

/**
 * Class ActionsCfdixml
 */

require_once DOL_DOCUMENT_ROOT . '/custom/cfdixml/class/ProcessManager.php';
require_once DOL_DOCUMENT_ROOT . '/core/lib/accounting.lib.php';
dol_include_once('/cfdixml/class/SQLiteController.php');


class ActionsCfdixml
{
	/**
	 * @var DoliDB Database handler.
	 */
	public $db;

	/**
	 * @var string Error code (or message)
	 */
	public $error = '';

	/**
	 * @var array Errors
	 */
	public $errors = array();


	/**
	 * @var array Hook results. Propagated to $hookmanager->resArray for later reuse
	 */
	public $results = array();

	/**
	 * @var string String displayed by executeHook() immediately after return
	 */
	public $resprints;

	/**
	 * @var int        Priority of hook (50 is used if value is not defined)
	 */
	public $priority;


	/**
	 * Constructor
	 *
	 * @param DoliDB $db Database handler
	 */
	public function __construct($db)
	{
		$this->db = $db;
	}


	/**
	 * Execute action
	 *
	 * @param array $parameters Array of parameters
	 * @param CommonObject $object The object to process (an invoice if you are in invoice module, a propale in propale's module, etc...)
	 * @param string $action 'add', 'update', 'view'
	 * @return    int                            <0 if KO,
	 *                                        =0 if OK but we want to process standard actions too,
	 *                                            >0 if OK and we want to replace standard actions.
	 */
	public function getNomUrl($parameters, &$object, &$action)
	{
		global $db, $langs, $conf, $user;
		$this->resprints = '';
		return 0;
	}

	/**
	 * Create From
	 */
	public function createFrom($parameters, $object, $action)
	{


		if (in_array($parameters['currentcontext'], array('invoicecard'))) {

			// if (GETPOST('action') == 'confirm_clone' && GETPOST('confirm') == 'yes') {
			// 	unset($parameters['objFrom']->array_options);
			// 	// echo '<pre>';
			// 	// print_r($parameters['objFrom']);
			// 	// exit;
			// 	$this->results = array('objFrom' => $parameters['objFrom']);
			// 	return 1;
			// }
		}
	}

	/**
	 * Overloading the doActions function : replacing the parent's function with the one below
	 *
	 * @param array $parameters Hook metadatas (context, etc...)
	 * @param CommonObject $object The object to process (an invoice if you are in invoice module, a propale in propale's module, etc...)
	 * @param string $action Current action (if set). Generally create or edit or null
	 * @param HookManager $hookmanager Hook manager propagated to allow calling another hook
	 * @return  int                             < 0 on error, 0 on success, 1 to replace standard code
	 */
	public function doActions($parameters, &$object, &$action, $hookmanager)
	{
		global $db, $user, $langs;


		try {
			$processManager = new ProcessManager($db, $user, $langs);

			switch ($parameters['currentcontext']) {
				case 'invoicecard':

					$params = array();
					$params['uso_cfdi'] = GETPOST('uso_cfdi', 'alpha');
					$params['condicion_pago'] = GETPOST('condicion_pago', 'alpha');
					// $params['forma_pago'] =;
					$params['metodo_pago'] = GETPOST('metodo_pago', 'alpha');
					$params['exportacion'] = GETPOST('exportacion', 'alpha');
					$params['forma_pago'] = $this->getSATCode(GETPOST('forma_pago', 'alpha'));

					if ($action == 'confirm_stamp' && GETPOST('confirm') == 'yes') {
						return $processManager->handleInvoice($params, $object, $action);
					}

					if ($action == 'confirm_add_complemento' && GETPOST('confirm') == 'yes') {
						$tipo_complemento = GETPOST('tipo_complemento', 'alpha');

						if ($tipo_complemento == 'sin_complemento') {
							// Cambiar acción a prestamp para levantar formulario de timbrado
							$action = 'prestamp';
							return 0; // Regresar para que formConfirm maneje la lógica
						}

						if ($tipo_complemento == 'carta_porte') {
							$action = 'add_ccp';
							return 0; // Regresar para que formConfirm maneje la lógica
						}

						if ($tipo_complemento == 'comercio_exterior') {
							$action = 'add_cce';
							return 0;
						}
					}

					if ($action == 'confirm_add_cce' && GETPOST('confirm') == 'yes') {
						dol_include_once('/cfdixml/class/cfdifacturecce.class.php');
						$cce = new CfdiFactureCce($db);
						$cce->fk_object = $object->id;
						$cce->version = GETPOST('version', 'alpha');
						$cce->motivo_traslado = GETPOST('motivo_traslado', 'alpha');
						$cce->clave_pedimento = GETPOST('clave_pedimento', 'alpha');
						$cce->certificado_origen = GETPOST('certificado_origen', 'alpha');
						$cce->num_certificado_origen = GETPOST('num_certificado_origen', 'alpha');
						$cce->numero_exportador_confiable = GETPOST('numero_exportador_confiable', 'alpha');
						$cce->incoterm = GETPOST('incoterm', 'alpha');
						$cce->observaciones = GETPOST('observaciones', 'alpha');
						$cce->tipo_cambio_usd = GETPOST('tipo_cambio_usd', 'alpha');
						$cce->total_usd = GETPOST('total_usd', 'alpha');

						$result = $cce->create($user);
						if ($result < 0) {
							$this->errors[] = $cce->error;
							return -1;
						} else {
							$action = 'prestamp';
							return 0;
						}
					}
					break;
				case 'expeditioncard':
					if ($action == 'generate_cfdi_traslado') {
						// Verificar permisos
						if (!$user->rights->expedition->lire) {
							accessforbidden();
						}

						// Cargar clase para CFDI de traslado
						dol_include_once('/cfdixml/class/cfditraslado.class.php');

						// Generar el CFDI
						$cfdiTraslado = new CFDITraslado($this->db);
						$cfdiTraslado->fetch($object->id);

						// Parámetros para el CFDI (podrían venir de un formulario)
						$params = array(
							'distance' => GETPOST('distance', 'int') ?: 100,
							'vehicle' => array(
								'plate' => GETPOST('plate', 'alpha'),
								'year' => GETPOST('year', 'int'),
								'type' => GETPOST('type', 'alpha'),
								'insurance' => GETPOST('insurance', 'alpha'),
								'policy' => GETPOST('policy', 'alpha')
							),
							'driver' => array(
								'rfc' => GETPOST('driver_rfc', 'alpha'),
								'name' => GETPOST('driver_name', 'alpha'),
								'license' => GETPOST('driver_license', 'alpha')
							),
							'international' => GETPOST('international', 'int') ? true : false,
							'debug' => GETPOST('debug', 'int') ? true : false
						);

						$result = $cfdiTraslado->generate($params);

						if ($result > 0) {
							setEventMessages($langs->trans('CFDITrasladoGenerated'), null, 'mesgs');
						} else {
							setEventMessages($cfdiTraslado->error, $cfdiTraslado->errors, 'errors');
						}

						// Redirigir para evitar reenvío del formulario
						$url = $_SERVER["PHP_SELF"] . '?id=' . $object->id;
						header('Location: ' . $url);
						exit;
					} // Acción para descargar CFDI
					else if ($action == 'download_cfdi_traslado') {
						// Verificar permisos
						if (!$user->rights->expedition->lire) {
							accessforbidden();
						}

						// Obtener el nombre del archivo
						$filename = $object->array_options['options_cfdi_traslado'] ?? '';

						if (!empty($filename)) {
							$filepath = DOL_DATA_ROOT . '/cfdixml/traslados/' . $filename;

							if (file_exists($filepath)) {
								// Configurar cabeceras para descarga
								header('Content-Description: File Transfer');
								header('Content-Type: application/xml');
								header('Content-Disposition: attachment; filename="' . $filename . '"');
								header('Expires: 0');
								header('Cache-Control: must-revalidate');
								header('Pragma: public');
								header('Content-Length: ' . filesize($filepath));

								// Leer y enviar el archivo
								readfile($filepath);
								exit;
							} else {
								setEventMessages($langs->trans('FileNotFound'), null, 'errors');
							}
						}
					} // Acción para cancelar CFDI
					else if ($action == 'cancel_cfdi_traslado') {
						// Verificar permisos
						if (!$user->rights->expedition->creer) {
							accessforbidden();
						}

						// Cargar clase para CFDI de traslado
						dol_include_once('/cfdixml/class/cfditraslado.class.php');

						// Cancelar el CFDI
						$cfdiTraslado = new CFDITraslado($this->db);
						$cfdiTraslado->fetch($object->id);

						$motivo = GETPOST('motivo', 'alpha') ?: '02';
						$result = $cfdiTraslado->cancel($motivo);

						if ($result > 0) {
							setEventMessages($langs->trans('CFDITrasladoCancelled'), null, 'mesgs');
						} else {
							setEventMessages($cfdiTraslado->error, $cfdiTraslado->errors, 'errors');
						}

						// Redirigir para evitar reenvío del formulario
						$url = $_SERVER["PHP_SELF"] . '?id=' . $object->id;
						header('Location: ' . $url);
						exit;
					}
					break;
			}

			return 0;
		} catch (Exception $e) {
			$this->errors[] = $e->getMessage();
			return -1;
		}
	}


	/**
	 * Overloading the doMassActions function : replacing the parent's function with the one below
	 *
	 * @param array $parameters Hook metadatas (context, etc...)
	 * @param CommonObject $object The object to process (an invoice if you are in invoice module, a propale in propale's module, etc...)
	 * @param string $action Current action (if set). Generally create or edit or null
	 * @param HookManager $hookmanager Hook manager propagated to allow calling another hook
	 * @return  int                             < 0 on error, 0 on success, 1 to replace standard code
	 */
	public function doMassActions($parameters, &$object, &$action, $hookmanager)
	{
		global $conf, $user, $langs;

		$error = 0; // Error counter

		/* print_r($parameters); print_r($object); echo "action: " . $action; */
		if (in_array($parameters['currentcontext'], array('somecontext1', 'somecontext2'))) {        // do something only for the context 'somecontext1' or 'somecontext2'
			foreach ($parameters['toselect'] as $objectid) {
				// Do action on each object id
			}
		}

		if (!$error) {
			$this->results = array('myreturn' => 999);
			$this->resprints = 'A text to show';
			return 0; // or return 1 to replace standard code
		} else {
			$this->errors[] = 'Error message';
			return -1;
		}
	}


	/**
	 * Overloading the addMoreMassActions function : replacing the parent's function with the one below
	 *
	 * @param array $parameters Hook metadatas (context, etc...)
	 * @param CommonObject $object The object to process (an invoice if you are in invoice module, a propale in propale's module, etc...)
	 * @param string $action Current action (if set). Generally create or edit or null
	 * @param HookManager $hookmanager Hook manager propagated to allow calling another hook
	 * @return  int                             < 0 on error, 0 on success, 1 to replace standard code
	 */
	public function addMoreMassActions($parameters, &$object, &$action, $hookmanager)
	{
		global $conf, $user, $langs;

		$error = 0; // Error counter
		$disabled = 1;

		/* print_r($parameters); print_r($object); echo "action: " . $action; */
		if (in_array($parameters['currentcontext'], array('invoicelist', 'somecontext2'))) {        // do something only for the context 'somecontext1' or 'somecontext2'
			$this->resprints = '<option value="0"' . ($disabled ? ' disabled="disabled"' : '') . '>' . $langs->trans("CfdixmlMassAction") . '</option>';
		}

		if (!$error) {
			return 0; // or return 1 to replace standard code
		} else {
			$this->errors[] = 'Error message';
			return -1;
		}
	}


	/**
	 * Execute action
	 *
	 * @param array $parameters Array of parameters
	 * @param Object $object Object output on PDF
	 * @param string $action 'add', 'update', 'view'
	 * @return  int                    <0 if KO,
	 *                                =0 if OK but we want to process standard actions too,
	 *                                >0 if OK and we want to replace standard actions.
	 */
	public function beforePDFCreation($parameters, &$object, &$action)
	{
		global $conf, $user, $langs;
		global $hookmanager;

		$outputlangs = $langs;

		$ret = 0;
		$deltemp = array();
		dol_syslog(get_class($this) . '::executeHooks action=' . $action);

		/* print_r($parameters); print_r($object); echo "action: " . $action; */
		if (in_array($parameters['currentcontext'], array('somecontext1', 'somecontext2'))) {        // do something only for the context 'somecontext1' or 'somecontext2'
		}

		return $ret;
	}

	/**
	 * Execute action
	 *
	 * @param array $parameters Array of parameters
	 * @param Object $pdfhandler PDF builder handler
	 * @param string $action 'add', 'update', 'view'
	 * @return  int                    <0 if KO,
	 *                                  =0 if OK but we want to process standard actions too,
	 *                                  >0 if OK and we want to replace standard actions.
	 */
	public function afterPDFCreation($parameters, &$pdfhandler, &$action)
	{
		global $conf, $user, $langs;
		global $hookmanager;

		$outputlangs = $langs;

		$ret = 0;
		$deltemp = array();
		dol_syslog(get_class($this) . '::executeHooks action=' . $action);

		/* print_r($parameters); print_r($object); echo "action: " . $action; */
		if (in_array($parameters['currentcontext'], array('somecontext1', 'somecontext2'))) {
			// do something only for the context 'somecontext1' or 'somecontext2'
		}

		return $ret;
	}


	/**
	 * Overloading the loadDataForCustomReports function : returns data to complete the customreport tool
	 *
	 * @param array $parameters Hook metadatas (context, etc...)
	 * @param string $action Current action (if set). Generally create or edit or null
	 * @param HookManager $hookmanager Hook manager propagated to allow calling another hook
	 * @return  int                             < 0 on error, 0 on success, 1 to replace standard code
	 */
	public function loadDataForCustomReports($parameters, &$action, $hookmanager)
	{
		global $conf, $user, $langs;

		$langs->load("cfdixml@cfdixml");

		$this->results = array();

		$head = array();
		$h = 0;

		if ($parameters['tabfamily'] == 'cfdixml') {
			$head[$h][0] = dol_buildpath('/module/index.php', 1);
			$head[$h][1] = $langs->trans("Home");
			$head[$h][2] = 'home';
			$h++;

			$this->results['title'] = $langs->trans("Cfdixml");
			$this->results['picto'] = 'cfdixml@cfdixml';
		}

		$head[$h][0] = 'customreports.php?objecttype=' . $parameters['objecttype'] . (empty($parameters['tabfamily']) ? '' : '&tabfamily=' . $parameters['tabfamily']);
		$head[$h][1] = $langs->trans("CustomReports");
		$head[$h][2] = 'customreports';

		$this->results['head'] = $head;

		return 1;
	}


	/**
	 * Overloading the restrictedArea function : check permission on an object
	 *
	 * @param array $parameters Hook metadatas (context, etc...)
	 * @param string $action Current action (if set). Generally create or edit or null
	 * @param HookManager $hookmanager Hook manager propagated to allow calling another hook
	 * @return  int                            <0 if KO,
	 *                                        =0 if OK but we want to process standard actions too,
	 *                                        >0 if OK and we want to replace standard actions.
	 */
	public function restrictedArea($parameters, &$action, $hookmanager)
	{
		global $user;

		if ($parameters['features'] == 'myobject') {
			if ($user->rights->cfdixml->myobject->read) {
				$this->results['result'] = 1;
				return 1;
			} else {
				$this->results['result'] = 0;
				return 1;
			}
		}

		return 0;
	}

	/**
	 * Execute action completeTabsHead
	 *
	 * @param array $parameters Array of parameters
	 * @param CommonObject $object The object to process (an invoice if you are in invoice module, a propale in propale's module, etc...)
	 * @param string $action 'add', 'update', 'view'
	 * @param Hookmanager $hookmanager hookmanager
	 * @return  int                             <0 if KO,
	 *                                          =0 if OK but we want to process standard actions too,
	 *                                          >0 if OK and we want to replace standard actions.
	 */
	public function completeTabsHead(&$parameters, &$object, &$action, $hookmanager)
	{
		global $langs, $conf, $user;

		if (!isset($parameters['object']->element)) {
			return 0;
		}
		if ($parameters['mode'] == 'remove') {
			// utilisé si on veut faire disparaitre des onglets.
			return 0;
		} elseif ($parameters['mode'] == 'add') {
			$langs->load('cfdixml@cfdixml');
			// utilisé si on veut ajouter des onglets.
			$counter = count($parameters['head']);
			$element = $parameters['object']->element;
			$id = $parameters['object']->id;
			// verifier le type d'onglet comme member_stats où ça ne doit pas apparaitre
			// if (in_array($element, ['societe', 'member', 'contrat', 'fichinter', 'project', 'propal', 'commande', 'facture', 'order_supplier', 'invoice_supplier'])) {
			if (in_array($element, ['context1', 'context2'])) {
				$datacount = 0;

				$parameters['head'][$counter][0] = dol_buildpath('/cfdixml/cfdixml_tab.php', 1) . '?id=' . $id . '&amp;module=' . $element;
				$parameters['head'][$counter][1] = $langs->trans('CfdixmlTab');
				if ($datacount > 0) {
					$parameters['head'][$counter][1] .= '<span class="badge marginleftonlyshort">' . $datacount . '</span>';
				}
				$parameters['head'][$counter][2] = 'cfdixmlemails';
				$counter++;
			}
			if ($counter > 0 && (int)DOL_VERSION < 14) {
				$this->results = $parameters['head'];
				// return 1 to replace standard code
				return 1;
			} else {
				// en V14 et + $parameters['head'] est modifiable par référence
				return 0;
			}
		}
	}

	public function formObjectOptions($parameters, $object, $action)
	{

		global $conf, $dolibarr_main_url_root;
		$string = '';
		if (in_array($parameters['currentcontext'], array('invoicecard'))) {
//			if ($action != 'create') {
//				print '<tr><td>Complementos</td><td>';
//				print '<ul style="list-style: none; padding: 0; margin: 0;">';
//				print '<li style="margin-bottom: 5px;">';
//				print '<a href="' . $_SERVER['PHP_SELF'] . '?id=' . $object->id . '&action=add_cce&token=' . newToken() . '" id="cce" class="butAction" style="font-size: 12px; padding: 5px 10px;">Complemento Comercio Exterior</a><span class="style_cce"></span>';
//				print '</li>';
//				print '<li style="margin-bottom: 5px;">';
//				print '<a href="' . $_SERVER['PHP_SELF'] . '?id=' . $object->id . '&action=add_ccp&token=' . newToken() . '" id="ccp" class="butAction" style="font-size: 12px; padding: 5px 10px;">Complemento Carta de Porte</a><span class="style_ccp"></span>';
//				print '</li>';
//				print '</ul>';
//				print '</td></tr>';
//			}
			if (!is_empty($object->status) && $object->statut != Facture::STATUS_DRAFT) {
				if ($object->array_options['options_cfdixml_UUID']) {

					$receptor = new Societe($this->db);

					$receptor->fetch($object->socid);

					$expresion = 'id=' . $object->array_options["options_cfdixml_UUID"] . '&re=' . $conf->global->MAIN_INFO_SIREN . '&rr=' . $receptor->idprof1 . '&tt=' . $object->total_ttc . '&fe=' . substr($object->array_options["options_cfdixml_sellocfd"], -8);

					$image = file_get_contents($conf->facture->dir_output . "/" . $object->ref . "/" . $object->ref . '_' . $object->array_options["options_cfdixml_UUID"] . ".png");
					$image = base64_encode($image);


					// echo '<pre>';print_r($creditos);exit;

					// $string = '<tr><td>UUID</td><td style="">' . $object->array_options['options_cfdixml_UUID'] . '</td></tr>';
					// $string .= '<tr><td>Fecha de timbrado</td><td style="">' . $object->array_options['options_cfdixml_fechatimbrado'] . '</td></tr>';
					// $string .= '<tr><td>Certificado SAT</td><td style="">' . $object->array_options['options_cfdixml_certsat'] . '</td></tr>';
					// $string .= '<tr><td>Certificado CFD</td><td style="">' . $object->array_options['options_cfdixml_certcfd'] . '</td></tr>';
					// $string .= '<tr><td>QR</td><td style=""><img src="' . $dolibarr_main_url_root . '/document.php?modulepart=facture&attachment=0&file=' . $object->ref . '_' . $object->array_options['options_cfdixml_UUID'] . '.png&entity=' . $conf->entity . '"></td></tr>';
					$string = '<tr><td>QR</td><td style=""><img src="data:image/png;base64,' . $image . '"></td></tr>';
					$string .= '<tr><td>Verificar CFDI</td><td style=""><a href="https://verificacfdi.facturaelectronica.sat.gob.mx/default.aspx?' . $expresion . '" target="_blank">' . $object->array_options['options_cfdixml_UUID'] . '</a></td></tr>';
				}


			}
			$this->resprints = $string;
			// echo $string;
			return 0;
		}
	}

	public function addMoreActionsButtons($parameters, $object, $action)
	{
		global $langs, $conf;

		if (in_array($parameters['currentcontext'], array('invoicecard'))) {
			$invoice = new Facture($this->db);

			// Timbrar ticket TakePOS
			if ($object->type == Facture::TYPE_REPLACEMENT) {
				$invoice->fetch($object->fk_facture_source);

				if (array_key_exists($object->status, [1, 4]) && !$object->array_options['options_cfdixml_UUID']) {
					echo '<a href="' . $_SERVER['PHP_SELF'] . '?id=' . $object->id . '&action=ask_complemento" class="butAction">Timbrar CFDI</a>';
				}
				if (array_key_exists($object->status, [1, 4]) && $object->array_options['options_cfdixml_UUID']) {
					echo '<a href="' . $_SERVER['PHP_SELF'] . '?id=' . $object->id . '&action=cancelxml" class="butActionDelete">Cancelar CFDI</a>';
					echo '<a href="' . $_SERVER['PHP_SELF'] . '?id=' . $object->id . '&action=rebuildpdf" class="butAction">Regenerar PDF</a>';
				}
			} else if (
				in_array($object->status, [1, 4]) &&
				empty($object->array_options['options_cfdixml_UUID']) &&
				$object->type != Facture::TYPE_REPLACEMENT ||
				$object->pos_source > 0 && empty($object->array_options["options_cfdixml_UUID"])
			) {
				if ($object->module_source) {
					echo '<a href="' . $_SERVER['PHP_SELF'] . '?id=' . $object->id . '&action=ask_complemento" class="butAction">Timbrar CFDI</a>';
				} else {
					echo '<a href="' . $_SERVER['PHP_SELF'] . '?id=' . $object->id . '&action=ask_complemento" class="butAction">Timbrar CFDI</a>';
				}
			} else if (in_array($object->status, [1, 4]) && $object->array_options['options_cfdixml_UUID']) {
				echo '<a href="' . $_SERVER['PHP_SELF'] . '?id=' . $object->id . '&action=cancelxml" class="butActionDelete">Cancelar CFDI</a>';
				echo '<a href="' . $_SERVER['PHP_SELF'] . '?id=' . $object->id . '&action=rebuildpdf" class="butAction">Regenerar PDF</a>';
			}
		}

		if (in_array($parameters['currentcontext'], array('paymentcard'))) {
			// No cambios aquí
		}

		if (in_array($parameters['currentcontext'], array('cfdixmlpaymentcard',))) {
			$payment = new Payment($this->db);
			$payment->fetch($object->id);

			if ($object->status == Payment::STATUS_VALIDATED && empty($payment->uuid) || $object->status == Payment::STATUS_TIMBRADO_FALLIDO && empty($payment->uuid)) {
				echo '<a href="' . $_SERVER['PHP_SELF'] . '?id=' . $object->id . '&action=prestamp" class="butAction">Timbrar Pago 2.0</a>';
			}
		}
	}
//	public function addMoreActionsButtons($parameters, $object, $action)
//{
//	global $langs, $conf;
//
//	if (in_array($parameters['currentcontext'], array('invoicecard'))) {
//
//		$invoice = new Facture($this->db);
//
//		//Timbrar ticket TakePOS
//
//		if ($object->type == Facture::TYPE_REPLACEMENT) {
//
//			$invoice->fetch($object->fk_facture_source);
//
//			if (array_key_exists($object->status, [1, 4]) && !$object->array_options['options_cfdixml_UUID']) {
//				echo '<a href="' . $_SERVER['PHP_SELF'] . '?id=' . $object->id . '&action=prestamp" class="butAction">Timbrar CFDI</a>';
//			}
//			if (array_key_exists($object->status, [1, 4]) && $object->array_options['options_cfdixml_UUID']) {
//				echo '<a href="' . $_SERVER['PHP_SELF'] . '?id=' . $object->id . '&action=cancelxml" class="butActionDelete">Cancelar CFDI</a>';
//				echo '<a href="' . $_SERVER['PHP_SELF'] . '?id=' . $object->id . '&action=rebuildpdf" class="butAction">Regenerar PDF</a>';
//			}
//		} else if (in_array($object->status, [1, 4]) && empty($object->array_options['options_cfdixml_UUID']) && $object->type != Facture::TYPE_REPLACEMENT || $object->pos_source > 0 && empty($object->array_options["options_cfdixml_UUID"])) {
//			if ($object->module_source) {
//				echo '<a href="' . $_SERVER['PHP_SELF'] . '?id=' . $object->id . '&action=change_invoice_series" class="butAction">Timbrar CFDI</a>';
//			} else {
//				echo '<a href="' . $_SERVER['PHP_SELF'] . '?id=' . $object->id . '&action=prestamp" class="butAction">Timbrar CFDI</a>';
//			}
//		} else if (in_array($object->status, [1, 4]) && $object->array_options['options_cfdixml_UUID']) {
//			echo '<a href="' . $_SERVER['PHP_SELF'] . '?id=' . $object->id . '&action=cancelxml" class="butActionDelete">Cancelar CFDI</a>';
//			echo '<a href="' . $_SERVER['PHP_SELF'] . '?id=' . $object->id . '&action=rebuildpdf" class="butAction">Regenerar PDF</a>';
//		}
//	}
//
//	if (in_array($parameters['currentcontext'], array('paymentcard'))) {
//	}
//
//	if (in_array($parameters['currentcontext'], array('cfdixmlpaymentcard',))) {
//
//		$payment = new Payment($this->db);
//		$payment->fetch($object->id);
//		// print_r($payment);
//		if ($object->status == Payment::STATUS_VALIDATED && empty($payment->uuid) || $object->status == Payment::STATUS_TIMBRADO_FALLIDO && empty($payment->uuid)) {
//			echo '<a href="' . $_SERVER['PHP_SELF'] . '?id=' . $object->id . '&action=prestamp" class="butAction">Timbrar Pago 2.0</a>';
//		}
//	}
//}

	// public function printFieldListValue($parameters, $object, $action)
	// {
	// 	echo '<td><span class="badge badge-status1 badge-status">Require REP</span></td>';
	// 	if (in_array($parameters['currentcontext'], array('paiementcard'))) {
	// 		$invoice = new Facture($this->db);

	// 		$invoice->fetch($object->facid);

	// 		if ($invoice->array_options['options_cfdixml_metodopago'] == 'PPD') {
	// 			echo '<td><span class="badge badge-status1 badge-status">Require REP</span></td>';
	// 		}
	// 	}
	// }
	public function formConfirm($parameters, $object, $action)
	{
		global $user, $langs;
		dol_include_once('/cfdixml/lib/cfdixml.lib.php');
		$form = new Form($this->db);
		$sqlitePath = dol_buildpath('/cfdixml/catalogs/catalogos.sqlite3', 0);

		if (in_array($parameters['currentcontext'], array('invoicecard',))) {
			if ($action == 'ask_complemento') {
				// Crear el formulario para seleccionar el complemento
				$formquestion = [
					'text' => '<h2>Seleccione el tipo de complemento para la factura ' . $object->ref . '</h2>',
					[
						'type' => 'select',
						'name' => 'tipo_complemento',
						'id' => 'tipo_complemento',
						'label' => 'Tipo de Complemento',
						'values' => [
							'sin_complemento' => 'Sin Complemento',
							'comercio_exterior' => 'Comercio Exterior'
						]
					]
				];

				$formconfirm = $form->formconfirm(
					$_SERVER["PHP_SELF"] . '?id=' . $object->id,
					$langs->trans('Seleccione Complemento'),
					'',
					'confirm_add_complemento',
					$formquestion,
					'',
					1,
					400,
					600
				);

				print $formconfirm;

				// Estilo adicional para el select
				echo '<script>$(document).ready(function(){
                $(".select2-container").css("width","20rem");
            });</script>';
			}

			if ($action == 'prestamp') {
				if (in_array($object->status, [1, 4]) && empty($object->array_options["options_cfdixml_UUID"]) || $object->pos_source > 0 && empty($object->array_options["options_cfdixml_UUID"])) {

					$resico = checkReceptor($object);

					if ($resico) {
						$revapply = 0;
						foreach ($object->lines as $line) {
							if ($line->product_type == 1) $revapply++;
						}
						if ($revapply > 0) {
							$sql = "SELECT f.revenuestamp FROM " . MAIN_DB_PREFIX . "facture f where rowid = " . $object->id;
							$resql = $this->db->query($sql);

							if ($resql) {
								$obj = $this->db->fetch_object($resql);
							}
							if (abs($obj->revenuestamp) <= 0) {
								setEventMessage('RESICO: Se debe aplicar la retención del 1.25%', 'warnings');
								return;
							}
						}
					}

					$form->load_cache_conditions_paiements();
					$form->load_cache_types_paiements();

					$conditionsPayment = getConditionsPayments($form->cache_conditions_paiements);
					$typesPayment = getTypesPayments($form->cache_types_paiements);
					$usocfdi = getDictionaryValues('usocfdi');
					$metodoPago = getDictionaryValues('metodopago');
					$exportacion = getDictionaryValues('exportacion');
					$disabled = 0;
					if (!empty($object->array_options["options_cfdixml_control"])) {
						$disabled = 1;
					}

					$formquestion = [
						'text' => '<h2>Timbrar factura ' . $object->ref . '</h2>',
						['type' => 'select', 'name' => 'uso_cfdi', 'id' => 'uso_cfdi', 'label' => 'Uso del CFDI', 'values' => $usocfdi, 'default' => $object->array_options['options_cfdixml_usocfdi'], 'multiple', 'select_disabled' => $disabled],
						['type' => 'select', 'name' => 'condicion_pago', 'id' => 'condicion_pago', 'label' => 'Condiciones de pago', 'values' => $conditionsPayment, 'default' => $object->cond_reglement_code, 'select_disabled' => $disabled],
						['type' => 'select', 'name' => 'forma_pago', 'id' => 'forma_pago', 'label' => 'Forma de pago', 'values' => $typesPayment, 'default' => $object->mode_reglement_code, 'select_disabled' => $disabled],
						['type' => 'select', 'name' => 'metodo_pago', 'id' => 'metodo_pago', 'label' => 'Método de pago', 'values' => $metodoPago, 'default' => $object->array_options['options_cfdixml_metodopago'], 'select_disabled' => $disabled],
						['type' => 'select', 'name' => 'exportacion', 'id' => 'exportacion', 'label' => 'Exportación', 'values' => $exportacion, 'default' => $object->array_options['options_cfdixml_exportacion'] ? $object->array_options['options_cfdixml_exportacion'] : '01', 'select_disabled' => $disabled],

					];

					$formconfirm = $form->formconfirm($_SERVER["PHP_SELF"] . '?id=' . $object->id, $langs->trans('stamp'), '', 'confirm_stamp', $formquestion, 0, 1, 420, 600);

					print $formconfirm;

					echo '<script>$(document).ready(function(){
				$(".select2-container").css("width","20rem");
				});</script>';
				}
			}

			if ($action == 'cancelxml') {
				$cancelacion = getDictionaryValues('cancelacion');
				$formquestion = [
					'text' => '<h2>Cancelar fiscalmente factura ' . $object->ref . '</h2>',
					['type' => 'select', 'name' => 'motivo', 'id' => 'motivo', 'label' => 'Motivo', 'values' => $cancelacion]

				];

				$formconfirm = $form->formconfirm($_SERVER["PHP_SELF"] . '?id=' . $object->id, $langs->trans('cancel'), '', 'confirm_cancel', $formquestion, 0, 1, 310, 500);

				print $formconfirm;

				echo '<script>$(document).ready(function(){
				$(".select2-container").css("width","20rem");
				});</script>';
			}
			if ($action == 'add_cce') {
				dol_include_once('/cfdixml/class/cfdifacturecce.class.php');
				$cce = new CfdiFactureCce($this->db);
				$cce->fetch('', $object->id);

				// Conexión al archivo SQLite para obtener catálogos
				$motivoTraslado = $this->getCatalogFromSQLite($sqlitePath, 'cce_20_motivos_traslado');
				$clavePedimento = $this->getCatalogFromSQLite($sqlitePath, 'cce_20_claves_pedimentos');
				$incoterm = $this->getCatalogFromSQLite($sqlitePath, 'cce_20_incoterms');
//				$certificadoOrigen = $this->getCatalogFromSQLite($sqlitePath, 'cce_20_certificados_origen');

				// Crear el formulario para Comercio Exterior
				$formquestion = [
					['type' => 'text', 'name' => 'version', 'label' => 'Versión', 'value' => '2.0', 'readonly' => true, 'disabled' => 'disabled'],
					[
						'type' => 'select',
						'name' => 'motivo_traslado',
						'label' => 'Motivo de Traslado',
						'values' => $motivoTraslado,
						'default' => $cce->motivo_traslado
					],
					[
						'type' => 'select',
						'name' => 'clave_pedimento',
						'label' => 'Clave de Pedimento',
						'values' => $clavePedimento,
						'default' => $cce->clave_pedimento
					],
					[
						'type' => 'select',
						'name' => 'certificado_origen',
						'label' => 'Certificado de Origen',
						'values' => [
							'0' => '0 - No funge como certificado de origen',
							'1' => '1 - Funge como certificado de origen'
						],
						'default' => $cce->certificado_origen
					],
					['type' => 'text', 'name' => 'num_certificado_origen', 'label' => 'Número de Certificado de Origen', 'default' => $cce->num_certificado_origen],
					['type' => 'text', 'name' => 'num_exportador_confiable', 'label' => 'Número de Exportador Confiable', 'default' => $cce->num_exportador_confiable],
					[
						'type' => 'select',
						'name' => 'incoterm',
						'label' => 'Incoterm',
						'values' => $incoterm,
						'default' => $cce->incoterm
					],
					['type' => 'textarea', 'name' => 'observaciones', 'label' => 'Observaciones', 'morecss' => 'quatrevingtpercent', 'default' => $cce->observaciones],
					['type' => 'text', 'name' => 'tipo_cambio_usd', 'label' => 'Tipo de Cambio USD', 'value' => $cce->tipo_cambio_usd ? $cce->tipo_cambio_usd : $object->multicurrency_tx, 'default' => $cce->tipo_cambio_usd],
					['type' => 'text', 'name' => 'total_usd', 'label' => 'Total USD', 'value' => $cce->total_usd ? $cce->total_usd : $object->multicurrency_total_ht, 'default' => $cce->total_usd],
				];

				// Generar el formulario de confirmación
				$formconfirm = $form->formconfirm(
					$_SERVER["PHP_SELF"] . '?id=' . $object->id,
					$langs->trans('Complemento Comercio Exterior'),
					'<h2>Agregar Complemento Comercio Exterior</h2>',
					'confirm_add_cce',
					$formquestion,
					'',
					1,
					600,
					800
				);

				print $formconfirm;
			}
//			if ($action == 'add_cce') {
//				// Conexión al archivo SQLite
//				$catalogData = $this->getCatalogFromSQLite($sqlitePath, 'cce_motivos_traslado'); // Cambiar por el catálogo requerido
//
//				// Crear el formulario para Comercio Exterior
//				$formquestion = [
//					['type' => 'text', 'name' => 'version', 'label' => 'Versión', 'value' => '2.0', 'readonly' => true],
//					[
//						'type' => 'select',
//						'name' => 'motivo_traslado',
//						'label' => 'Motivo de Traslado',
//						'values' => $catalogData
//					],
//					['type' => 'text', 'name' => 'total_usd', 'label' => 'Total USD', 'value' => $object->multicurrency_total_ht, 'readonly' => true],
//					['type' => 'text', 'name' => 'tipo_cambio_usd', 'label' => 'Tipo de Cambio USD', 'value' => $object->multicurrency_tx, 'readonly' => true],
//				];
//
//				$formconfirm = $form->formconfirm(
//					$_SERVER["PHP_SELF"] . '?id=' . $object->id,
//					$langs->trans('Complemento Comercio Exterior'),
//					'<h2>Agregar Complemento Comercio Exterior</h2>',
//					'confirm_add_cce',
//					$formquestion,
//					'',
//					1,
//					480,
//					640
//				);
//
//				print $formconfirm;
//			}

			if ($action == 'add_ccp') {
				// Mantener lógica existente
			}
		}

		if (in_array($parameters['currentcontext'], array('cfdixmlpaymentcard'))) {
			if ($action == 'prestamp' && $object->status == Payment::STATUS_VALIDATED || $object->status == Payment::STATUS_TIMBRADO_FALLIDO) {
				$page = $_SERVER['PHP_SELF'] . "?id={$object->id}";
				$title = "Confirmación de Timbrado";
				$question = "¿Desea timbrar el siguiente Complemento de Pago?";
				$action = "confirm_stamp";
				$useajax = 1;

				echo $form->formConfirm($page, $title, $question, $action, null, '', $useajax);
			}
		}


	}

//	public function formConfirm($parameters, $object, $action)
//	{
//		global $user, $langs;
//		dol_include_once('/cfdixml/lib/cfdixml.lib.php');
//		$form = new Form($this->db);
//
//		if (in_array($parameters['currentcontext'], array('invoicecard',))) {
//			if ($object->module_source) {
//				if ($action == 'change_invoice_series') {
//					$facture = new Facture($this->db);
//					$numref = $facture->getNextNumRef($object->thirdparty);
//					$text = $langs->trans('ConfirmValidateBill', $numref);
//					$formquestion = array();
//					$formconfirm = $form->formconfirm($_SERVER["PHP_SELF"] . '?facid=' . $object->id, $langs->trans('ValidateBill'), $text, 'confirm_change_invoice_series', $formquestion, (($object->type != Facture::TYPE_CREDIT_NOTE && $object->total_ttc < 0) ? "no" : "yes"), 2);
//
//					print $formconfirm;
//				}
//			}
//			if ($action == 'prestamp') {
//
//				if (in_array($object->status, [1, 4]) && empty($object->array_options["options_cfdixml_UUID"]) || $object->pos_source > 0 && empty($object->array_options["options_cfdixml_UUID"])) {
//
//					$resico = checkReceptor($object);
//
//					if ($resico) {
//						$revapply = 0;
//						foreach ($object->lines as $line) {
//							if ($line->product_type == 1) $revapply++;
//						}
//						if ($revapply > 0) {
//							$sql = "SELECT f.revenuestamp FROM " . MAIN_DB_PREFIX . "facture f where rowid = " . $object->id;
//							$resql = $this->db->query($sql);
//
//							if ($resql) {
//								$obj = $this->db->fetch_object($resql);
//							}
//							if (abs($obj->revenuestamp) <= 0) {
//								setEventMessage('RESICO: Se debe aplicar la retención del 1.25%', 'warnings');
//								return;
//							}
//						}
//					}
//
//					$form->load_cache_conditions_paiements();
//					$form->load_cache_types_paiements();
//
//					$conditionsPayment = getConditionsPayments($form->cache_conditions_paiements);
//					$typesPayment = getTypesPayments($form->cache_types_paiements);
//					$usocfdi = getDictionaryValues('usocfdi');
//					$metodoPago = getDictionaryValues('metodopago');
//					$exportacion = getDictionaryValues('exportacion');
//					$disabled = 0;
//					if (!empty($object->array_options["options_cfdixml_control"])) {
//						$disabled = 1;
//					}
//
//					$formquestion = [
//						'text' => '<h2>Timbrar factura ' . $object->ref . '</h2>',
//						['type' => 'select', 'name' => 'uso_cfdi', 'id' => 'uso_cfdi', 'label' => 'Uso del CFDI', 'values' => $usocfdi, 'default' => $object->array_options['options_cfdixml_usocfdi'], 'multiple', 'select_disabled' => $disabled],
//						['type' => 'select', 'name' => 'condicion_pago', 'id' => 'condicion_pago', 'label' => 'Condiciones de pago', 'values' => $conditionsPayment, 'default' => $object->cond_reglement_code, 'select_disabled' => $disabled],
//						['type' => 'select', 'name' => 'forma_pago', 'id' => 'forma_pago', 'label' => 'Forma de pago', 'values' => $typesPayment, 'default' => $object->mode_reglement_code, 'select_disabled' => $disabled],
//						['type' => 'select', 'name' => 'metodo_pago', 'id' => 'metodo_pago', 'label' => 'Método de pago', 'values' => $metodoPago, 'default' => $object->array_options['options_cfdixml_metodopago'], 'select_disabled' => $disabled],
//						['type' => 'select', 'name' => 'exportacion', 'id' => 'exportacion', 'label' => 'Exportación', 'values' => $exportacion, 'default' => $object->array_options['options_cfdixml_exportacion'] ? $object->array_options['options_cfdixml_exportacion'] : '01', 'select_disabled' => $disabled],
//
//					];
//
//					$formconfirm = $form->formconfirm($_SERVER["PHP_SELF"] . '?id=' . $object->id, $langs->trans('stamp'), '', 'confirm_stamp', $formquestion, 0, 1, 420, 600);
//
//					print $formconfirm;
//
//					echo '<script>$(document).ready(function(){
//				$(".select2-container").css("width","20rem");
//				});</script>';
//				}
//			}
//			if ($action == 'cancelxml') {
//				$cancelacion = getDictionaryValues('cancelacion');
//				$formquestion = [
//					'text' => '<h2>Cancelar fiscalmente factura ' . $object->ref . '</h2>',
//					['type' => 'select', 'name' => 'motivo', 'id' => 'motivo', 'label' => 'Motivo', 'values' => $cancelacion]
//
//				];
//
//				$formconfirm = $form->formconfirm($_SERVER["PHP_SELF"] . '?id=' . $object->id, $langs->trans('cancel'), '', 'confirm_cancel', $formquestion, 0, 1, 310, 500);
//
//				print $formconfirm;
//
//				echo '<script>$(document).ready(function(){
//				$(".select2-container").css("width","20rem");
//				});</script>';
//			}
//
//			if (isModEnabled('incoterm')) {
//				if ($action == 'add_cce') {
//
//					// Obtener los datos automáticos de Dolibarr
//					$tipo_cambio_usd = $object->multicurrency_tx; // Supongamos que este campo contiene el tipo de cambio USD
//					$total_usd = $object->multicurrency_total_ht; // Total en USD desde Dolibarr
//					$incoterm = $object->shipping_method; // Supongamos que el módulo Incoterm utiliza este campo
//
//					// Formulario de preguntas
//					$formquestion = [
//						[
//							'type' => 'text',
//							'name' => 'version',
//							'label' => 'Versión',
//							'value' => '2.0', // Versión predefinida
//							'readonly' => true
//						],
//						[
//							'type' => 'select',
//							'name' => 'motivo_traslado',
//							'label' => 'Motivo de Traslado',
//							'values' => [
//								['value' => '99', 'label' => '99 - Otros']
//							]
//						],
//						[
//							'type' => 'select',
//							'name' => 'clave_pedimento',
//							'label' => 'Clave de Pedimento',
//							'values' => [
//								['value' => 'A1', 'label' => 'A1 - Importación o Exportación Definitiva']
//							]
//						],
//						[
//							'type' => 'select',
//							'name' => 'certificado_origen',
//							'label' => 'Certificado de Origen',
//							'values' => [
//								['value' => '0', 'label' => '0 - No Funge como certificado de origen'],
//								['value' => '1', 'label' => '1 - Funge como certificado de origen']
//							]
//						],
//						[
//							'type' => 'text',
//							'name' => 'num_certificado_origen',
//							'label' => 'Número de Certificado de Origen'
//						],
//						[
//							'type' => 'text',
//							'name' => 'num_exportador_confiable',
//							'label' => 'Número Exportador Confiable'
//						],
//
//						[
//							'type' => 'textarea',
//							'name' => 'observaciones',
//							'label' => 'Observaciones',
//							'value' => '0'
//						],
//						[
//							'type' => 'text',
//							'name' => 'tipo_cambio_usd',
//							'label' => 'Tipo de Cambio USD',
//							'value' => $tipo_cambio_usd,
//							'readonly' => true
//						],
//						[
//							'type' => 'text',
//							'name' => 'total_usd',
//							'label' => 'Total USD',
//							'value' => $total_usd,
//							'readonly' => true
//						]
//					];
//
//					// Formulario de confirmación
//					$formconfirm = $form->formconfirm(
//						$_SERVER["PHP_SELF"] . '?id=' . $object->id,
//						$langs->trans('Complemento Carta Porte'),
//						'<h2>Agregar Complemento Carta Porte</h2>',
//						'confirm_add_ccp',
//						$formquestion,
//						'',
//						1,
//						480,
//						640
//					);
//
//					print $formconfirm;
//
//					// Ajustes adicionales en estilos
//					echo '<script>$(document).ready(function(){
//        $(".select2-container").css("width","20rem");
//    });</script>';
//				}
//			}
//			if ($action == 'add_ccp') {
//			}
//		}
//
//
//		if (in_array($parameters['currentcontext'], array('cfdixmlpaymentcard'))) {
//
//			$payment = new Payment($this->db);
//			$payment->fetch($object->id);
//
//			if ($action == 'prestamp' && $object->status == Payment::STATUS_VALIDATED || $object->status == Payment::STATUS_TIMBRADO_FALLIDO) {
//				// Definir los parámetros para el diálogo de confirmación
//				$page = $_SERVER['PHP_SELF'] . "?id={$object->id}";  // Asegúrate de que `your_script.php` maneje la lógica del 'action'
//				$title = "Confirmación de Timbrado";
//				$question = "¿Desea timbrar el siguiente Complemento de Pago?";
//				$action = "confirm_stamp"; // Esta acción debería ser manejada en your_script.php
//				$useajax = 1;
//
//				// Llamada a la función formConfirm
//				echo $form->formConfirm($page, $title, $question, $action, null, '', $useajax);
//			}
//		}
//	}

	public function getFormMail($parameters, &$object, &$action, $hookmanager)
	{
		global $conf;
		if (in_array($parameters['currentcontext'], array('invoicecard'))) {

			$invoice = new Facture($this->db);
			$invoice->fetch(GETPOST('facid'));

			$objectref = dol_sanitizeFileName($invoice->ref);
			$dir = $conf->facture->dir_output . "/" . $objectref;
			$file = $dir . "/" . $objectref . '_' . $invoice->array_options['options_cfdixml_UUID'] . ".xml";

			$object->add_attached_files($file);

			$file = $dir . "/" . $objectref . '_' . $invoice->array_options['options_cfdixml_UUID'] . ".pdf";

			$object->add_attached_files($file);

			return;
		}
	}


	public function printFieldListTitle($parameters, $objp, $action)
	{
		//TODO: Add $langs to trans this hardcoded string
		// print '<td>Tipo de Cambio</td>';
		// print '<td>Estado de la factura</td>';
	}

	public function printFieldListValue($parameters, $objp, $action)
	{
		global $langs, $form, $conf;
		// echo '<pre>';print_r($_POST);echo '</pre>';
		if (in_array($parameters['currentcontext'], array('paiementcard'))) {
			$tc_val = GETPOST('tc_' . $objp->facid, 'alpha');
			$disabled = '';
			if ($objp->multicurrency_code == "MXN" || $action == 'add_paiement') {
				$disabled = 'disabled';
				// Generar input de tipo hidden con el mismo nombre y valor
				print '<input type="hidden" name="tc_' . $objp->facid . '" value="' . $tc_val . '">';
			}
			// Modificar el nombre del input si $disabled está lleno
			$input_name = $disabled ? 'disabled' : 'tc_' . $objp->facid;
			print '<td><input type="text" class="maxwidth75" name="' . $input_name . '" value="' . $tc_val . '" ' . $disabled . '></td>';

			$invoice = new Facture($this->db);

			$invoice->fetch($objp->facid);
			$invoice->fetch_optionals();
			if ($invoice->array_options['options_cfdixml_metodopago'] == 'PPD' && !empty($invoice->array_options['options_cfdixml_UUID'])) {
				print '<td>Require REP</td>';
			} else if ($invoice->array_options['options_cfdixml_metodopago'] == 'PPD' && empty($invoice->array_options['options_cfdixml_UUID'])) {
				print '<td>No Timbrada PPD</td>';
			} else {
				print '<td>No Timbrada</td>';
			}
		}
	}

	public function showLinkedObjectBlock($parameters, $object, $action)
	{
		global $langs, $conf;

		if (in_array($parameters['currentcontext'], array('invoicecard'))) {
			if (isModEnabled('incoterm')) {
				dol_include_once('/cfdixml/class/cfdifacturecce.class.php');
				$objectCce = new CfdiFactureCce($this->db);
				$objectCce->fetch(0, $object->id);
				if ($objectCce->rowid > 0) { // Verifica si se encontraron datos

					print '<div class="div-table-responsive-no-min">';
					print '<table><tr><td colspan="2"></td></tr></table>';
					print '<table class="noborder allwidth showlinkedobjectblock" data-block="showLinkedCCE" data-element="complemento_comercio_exterior" data-elementid="' . $object->id . '">';


					// Título de la tabla
					print '<tr class="liste_titre">';
					print '<td colspan="2">' . $langs->trans('Complemento Comercio Exterior') . '</td>';
					print '</tr>';

					// Campos del Complemento Comercio Exterior
					$fields = [
						['label' => 'Versión', 'value' => $objectCce->version],
						['label' => 'Motivo de Traslado', 'value' => $objectCce->motivo_traslado],
						['label' => 'Clave de Pedimento', 'value' => $objectCce->clave_pedimento],
						['label' => 'Certificado de Origen', 'value' => $objectCce->certificado_origen],
						['label' => 'Número de Certificado de Origen', 'value' => $objectCce->num_certificado_origen],
						['label' => 'Número Exportador Confiable', 'value' => $objectCce->numero_exportador_confiable],
						['label' => 'Incoterm', 'value' => $object->display_incoterms()],
						['label' => 'Observaciones', 'value' => $objectCce->observaciones],
						['label' => 'Tipo de Cambio USD', 'value' => $objectCce->tipo_cambio_usd],
						['label' => 'Total USD', 'value' => $objectCce->total_usd],
					];

					// Mostrar cada campo como una fila
					foreach ($fields as $field) {
						print '<tr>';
						print '<td width="50%">' . $langs->trans($field['label']) . '</td>';
						print '<td>' . dol_escape_htmltag($field['value']) . '</td>';
						print '</tr>';
					}

					print '</table>';
					print '</div>';
				} else {
					// Mensaje si no hay datos disponibles
					print '<div class="div-table-responsive-no-min">';
					print '<table class="noborder allwidth">';
					print '<tr><td colspan="2" class="opacitymedium">' . $langs->trans("NoCCEData") . '</td></tr>';
					print '</table>';
					print '</div>';
				}
			}
		}
	}

	/**
	 * Get code from SAT Catalog
	 */
	private function getSATCode($code)
	{
		$sql = "SELECT code FROM " . MAIN_DB_PREFIX . "cfdixml_forma_pago WHERE fk_c_paiement = " . dol_getIdFromCode($this->db, $code, 'c_paiement');
		$resql = $this->db->query($sql);
		if ($resql) {
			$obj = $this->db->fetch_object($resql);
		}
		return isset($obj) ? $obj->code : null;
	}

	/**
	 * Obtiene los valores de un catálogo desde un archivo SQLite
	 *
	 * @param string $sqlitePath Ruta del archivo SQLite
	 * @param string $tableName Nombre de la tabla en SQLite
	 * @return array Catálogo de datos
	 */
	private function getCatalogFromSQLite($sqlitePath, $tableName)
	{
		if (!file_exists($sqlitePath)) {
			throw new RuntimeException("Archivo SQLite no encontrado en la ruta: $sqlitePath");
		}

		try {
			$pdo = new PDO("sqlite:$sqlitePath");
			$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

			// Obtener las columnas de la tabla
			$columnsQuery = "PRAGMA table_info($tableName)";
			$columnsStmt = $pdo->query($columnsQuery);
			$columns = [];
			while ($column = $columnsStmt->fetch(PDO::FETCH_ASSOC)) {
				$columns[] = $column['name'];
			}

			if (empty($columns)) {
				throw new RuntimeException("No se encontraron columnas en la tabla: $tableName");
			}

			// Construir la consulta para obtener los datos
			$labelColumns = array_filter($columns, fn($col) => $col !== 'id'); // Excluir 'id' del label
			$concatLabels = implode(" || ' ' || ", $labelColumns);

			$query = "SELECT id AS value, id || ' - ' || $concatLabels AS label FROM $tableName ORDER BY id";
			$stmt = $pdo->query($query);

			$catalog = [];
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$catalog[$row['value']] = $row['label'];
			}

			return $catalog;
		} catch (PDOException $e) {
			throw new RuntimeException("Error al consultar el catálogo desde SQLite: " . $e->getMessage());
		}
	}
}

