<?php
/* Copyright (C) 2004-2017 Laurent Destailleur  <eldy@users.sourceforge.net>
 * Copyright (C) 2022 Alice Adminson <aadminson@example.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

/**
 * \file    cfdixml/admin/about.php
 * \ingroup cfdixml
 * \brief   About page of module Cfdixml.
 */

// Load Dolibarr environment
$res = 0;
// Try main.inc.php into web root known defined into CONTEXT_DOCUMENT_ROOT (not always defined)
if (!$res && !empty($_SERVER["CONTEXT_DOCUMENT_ROOT"])) {
	$res = @include $_SERVER["CONTEXT_DOCUMENT_ROOT"] . "/main.inc.php";
}
// Try main.inc.php into web root detected using web root calculated from SCRIPT_FILENAME
$tmp = empty($_SERVER['SCRIPT_FILENAME']) ? '' : $_SERVER['SCRIPT_FILENAME'];
$tmp2 = realpath(__FILE__);
$i = strlen($tmp) - 1;
$j = strlen($tmp2) - 1;
while ($i > 0 && $j > 0 && isset($tmp[$i]) && isset($tmp2[$j]) && $tmp[$i] == $tmp2[$j]) {
	$i--;
	$j--;
}
if (!$res && $i > 0 && file_exists(substr($tmp, 0, ($i + 1)) . "/main.inc.php")) {
	$res = @include substr($tmp, 0, ($i + 1)) . "/main.inc.php";
}
if (!$res && $i > 0 && file_exists(dirname(substr($tmp, 0, ($i + 1))) . "/main.inc.php")) {
	$res = @include dirname(substr($tmp, 0, ($i + 1))) . "/main.inc.php";
}
// Try main.inc.php using relative path
if (!$res && file_exists("../../main.inc.php")) {
	$res = @include "../../main.inc.php";
}
if (!$res && file_exists("../../../main.inc.php")) {
	$res = @include "../../../main.inc.php";
}
if (!$res) {
	die("Include of main fails");
}

// Libraries
require_once DOL_DOCUMENT_ROOT . '/core/lib/admin.lib.php';
require_once DOL_DOCUMENT_ROOT . '/core/lib/functions2.lib.php';
require_once '../lib/cfdixml.lib.php';

// Translations
$langs->loadLangs(array("errors", "admin", "cfdixml@cfdixml", 'bills', 'companies', 'compta', 'products', 'banks', 'main', 'withdrawals'));


// Access control
if (!$user->admin) {
	accessforbidden();
}

// Parameters
$action = GETPOST('action', 'aZ09');
$backtopage = GETPOST('backtopage', 'alpha');


/*
 * Actions
 */

if ($action == 'save') {
	$error = 0;

	foreach ($_POST as $key => $value) {
		if (is_numeric($key) && !empty($value)) {
			$sql = "SELECT count(*) as nb FROM " . MAIN_DB_PREFIX . "cfdixml_forma_pago WHERE fk_c_paiement = " . $key;

			$result = $db->query($sql);
			if ($result) {
				$obj = $db->fetch_object($result);
				if ($obj->nb > 0) {
					$sql = "UPDATE " . MAIN_DB_PREFIX . "cfdixml_forma_pago SET code = '" . $value . "', label = '" . $langs->trans($value) . "' WHERE fk_c_paiement = '" . $key . "'";

					$result = $db->query($sql);
					if ($result < 0) {
						$error++;
					}
				} else {
					$sql = "INSERT INTO " . MAIN_DB_PREFIX . "cfdixml_forma_pago (fk_c_paiement, code, label) ";
					$sql .= " VALUES (" . $key . ", '" . $value . "', '" . $langs->trans($value) . "')";

					$result = $db->query($sql);
					if ($result < 0) {

						$error++;
					}
				}
			} else {
				$sql = "INSERT INTO " . MAIN_DB_PREFIX . "cfdixml_forma_pago (fk_c_paiement, code, label) ";
				$sql .= " VALUES (" . $key . ", '" . $value . "', '" . $langs->trans($value) . "')";

				$result = $db->query($sql);
				if ($result < 0) {

					$error++;
				}
			}
		}
	}
	if ($error > 0) {
		setEventMessages($langs->trans('Error'), null, 'errors');
	} else {
		setEventMessage($langs->trans('CfdixmlFormaPagoSaved'), 'info');
	}

	header("Location: " . $_SERVER["PHP_SELF"]);
	exit;
}
// None


/*
 * View
 */

$form = new Form($db);

$help_url = '';
$page_name = "CfdixmlPagos";

llxHeader('', $langs->trans($page_name), $help_url);

// Subheader
$linkback = '<a href="' . ($backtopage ? $backtopage : DOL_URL_ROOT . '/admin/modules.php?restore_lastsearch_values=1') . '">' . $langs->trans("BackToModuleList") . '</a>';

print load_fiche_titre($langs->trans($page_name), $linkback, 'title_setup');

// Configuration header
$head = cfdixmlAdminPrepareHead();
print dol_get_fiche_head($head, 'pagos', $langs->trans($page_name), 0, 'cfdixml@cfdixml');

dol_include_once('/cfdixml/core/modules/modCfdixml.class.php');




$sql = "SELECT p.id, p.code, p.libelle, c.code as cfdicode ,c.label as cfdilabel FROM " . MAIN_DB_PREFIX . "c_paiement p";
$sql .= " LEFT JOIN " . MAIN_DB_PREFIX . "cfdixml_forma_pago c on p.id = c.fk_c_paiement";
$sql .= " WHERE active = 1";

$resql = $db->query($sql);
$paiements = array();
if ($resql) {
	while ($obj = $db->fetch_object($resql)) {
		array_push($paiements, $obj);
	}
}

/*
view
*/
print '<form method="POST" action="' . $_SERVER["PHP_SELF"] . '">';
print '<input type="hidden" name="token" value="' . newToken() . '">';
print '<input type="hidden" name="action" value="save" />';
print '<table class="border" width="100%">';
print '<tr class="liste_titre">';
print '<td>Dolibarr</td>';
print '<td>SAT</td>';
print '</tr>';
foreach ($paiements as $p) {
	print '<tr class="oddeven">';
	print '<td>' . $p->code . ' - ' . $langs->trans($p->libelle) . '</td>';
	print '<td>';
	print $p->cfdilabel . ' - <input type="text" name="' . $p->id . '" value="'.$p->cfdicode . '"size="10" />';
	print '</td>';
	print '</tr>';
}
print '<tr><td>';

print '</td><td>';
print '<input type="submit" class="butAction" value="' . $langs->trans("Save") . '" name="save" />';
print '</td></tr>';
print '</table>';


// Page end
print dol_get_fiche_end();
llxFooter();
$db->close();
