<?php
/* Copyright (C) 2004-2017 Laurent Destailleur  <eldy@users.sourceforge.net>
 * Copyright (C) 2022 Alice Adminson <aadminson@example.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

/**
 * \file    cfdixml/admin/about.php
 * \ingroup cfdixml
 * \brief   About page of module Cfdixml.
 */

// Load Dolibarr environment
$res = 0;
// Try main.inc.php into web root known defined into CONTEXT_DOCUMENT_ROOT (not always defined)
if (!$res && !empty($_SERVER["CONTEXT_DOCUMENT_ROOT"])) {
	$res = @include $_SERVER["CONTEXT_DOCUMENT_ROOT"] . "/main.inc.php";
}
// Try main.inc.php into web root detected using web root calculated from SCRIPT_FILENAME
$tmp = empty($_SERVER['SCRIPT_FILENAME']) ? '' : $_SERVER['SCRIPT_FILENAME'];
$tmp2 = realpath(__FILE__);
$i = strlen($tmp) - 1;
$j = strlen($tmp2) - 1;
while ($i > 0 && $j > 0 && isset($tmp[$i]) && isset($tmp2[$j]) && $tmp[$i] == $tmp2[$j]) {
	$i--;
	$j--;
}
if (!$res && $i > 0 && file_exists(substr($tmp, 0, ($i + 1)) . "/main.inc.php")) {
	$res = @include substr($tmp, 0, ($i + 1)) . "/main.inc.php";
}
if (!$res && $i > 0 && file_exists(dirname(substr($tmp, 0, ($i + 1))) . "/main.inc.php")) {
	$res = @include dirname(substr($tmp, 0, ($i + 1))) . "/main.inc.php";
}
// Try main.inc.php using relative path
if (!$res && file_exists("../../main.inc.php")) {
	$res = @include "../../main.inc.php";
}
if (!$res && file_exists("../../../main.inc.php")) {
	$res = @include "../../../main.inc.php";
}
if (!$res) {
	die("Include of main fails");
}

// Libraries
require_once DOL_DOCUMENT_ROOT . '/core/lib/admin.lib.php';
require_once DOL_DOCUMENT_ROOT . '/core/lib/functions2.lib.php';
require_once '../lib/cfdixml.lib.php';
require_once '../class/addenda/cfdixmladdenda.class.php';


// Translations
$langs->loadLangs(array('admin', 'cfdixml@cfdixml'));

// Access control
if (!$user->admin) accessforbidden();

// Parameters
$action = GETPOST('action', 'alpha');
$id = GETPOST('id', 'int');

// Initialize technical objects
$form = new Form($db);
$addenda = new CfdixmlAddenda($db);

/*
 * Actions
 */
if ($action == 'activate' && !empty($id)) {
    $db->begin();
    $error = 0;

    // Activar la addenda
    $result = $addenda->setStatus($id, 1);
    if ($result <= 0) {
        $error++;
        setEventMessages($langs->trans("ErrorActivatingAddenda"), null, 'errors');
    }

    if (!$error) {
        // Crear extrafields configurados
        require_once DOL_DOCUMENT_ROOT.'/core/class/extrafields.class.php';
        $extrafields = new ExtraFields($db);

        $configuredExtrafields = $addenda->getConfiguredExtrafields($id);
        if ($configuredExtrafields !== false) {
            if (!empty($configuredExtrafields)) {
                $result = $addenda->createConfiguredExtrafields($id, $extrafields);
                if ($result <= 0) {
                    $error++;
                    setEventMessages($langs->trans("ErrorCreatingExtraFields"), null, 'errors');
                }
            }
        } else {
            $error++;
            setEventMessages($langs->trans("ErrorLoadingExtraFields"), null, 'errors');
        }
    }

    if ($error) {
        $db->rollback();
        setEventMessages($addenda->error, $addenda->errors, 'errors');
    } else {
        $db->commit();
        setEventMessages($langs->trans("AddendaActivated"), null, 'mesgs');
    }

    header("Location: ".$_SERVER['PHP_SELF']);
    exit;
}

if ($action == 'deactivate' && !empty($id)) {
    $db->begin();
    $error = 0;

    // Desactivar la addenda
    $result = $addenda->setStatus($id, 0);
    if ($result <= 0) {
        $error++;
        setEventMessages($langs->trans("ErrorDeactivatingAddenda"), null, 'errors');
    }

    if ($error) {
        $db->rollback();
    } else {
        $db->commit();
        setEventMessages($langs->trans("AddendaDeactivated"), null, 'mesgs');
    }

    header("Location: ".$_SERVER['PHP_SELF']);
    exit;
}

/*
 * View
 */

$page_name = "AddendaSetup";
llxHeader('', $langs->trans($page_name));

$linkback = '<a href="'.DOL_URL_ROOT.'/admin/modules.php?restore_lastsearch_values=1">'.$langs->trans("BackToModuleList").'</a>';
print load_fiche_titre($langs->trans($page_name), $linkback, 'title_setup');

// Configuration header
$head = cfdixmlAdminPrepareHead();
print dol_get_fiche_head($head, 'addenda', $langs->trans($page_name), -1, 'cfdixml@cfdixml');

// Available Addendas Section
print '<div class="div-table-responsive-no-min">';
print '<form method="POST" action="'.$_SERVER["PHP_SELF"].'">';
print '<input type="hidden" name="token" value="'.newToken().'">';
print '<input type="hidden" name="action" value="activate">';

print '<table class="noborder centpercent">';
print '<tr class="liste_titre">';
print '<td>'.$langs->trans("AvailableAddendas").'</td>';
print '<td>'.$langs->trans("Action").'</td>';
print '</tr>';

// Get inactive addendas
$sql = "SELECT rowid, addenda, class FROM ".MAIN_DB_PREFIX."cfdixml_addenda WHERE fk_status = 0";
$resql = $db->query($sql);

if ($resql) {
    $num = $db->num_rows($resql);
    if ($num > 0) {
        while ($obj = $db->fetch_object($resql)) {
            print '<tr class="oddeven">';
            print '<td>'.$obj->addenda.'</td>';
            print '<td class="right">';
            print '<a class="butAction" href="'.$_SERVER["PHP_SELF"].'?action=activate&amp;id='.$obj->rowid.'&token='.newToken().'">'.$langs->trans("Activate").'</a>';
            print '</td>';
            print '</tr>';
        }
    } else {
        print '<tr><td colspan="2"><span class="opacitymedium">'.$langs->trans("NoInactiveAddendas").'</span></td></tr>';
    }
}

print '</table>';
print '</form>';
print '</div>';
print '<br>';

// Active Addendas Section
print '<div class="div-table-responsive-no-min">';
print '<table class="noborder centpercent">';
print '<tr class="liste_titre">';
print '<td>'.$langs->trans("ActiveAddendas").'</td>';
print '<td>'.$langs->trans("Class").'</td>';
print '<td width="80px">'.$langs->trans("Action").'</td>';
print '</tr>';

// Get active addendas
$sql = "SELECT rowid, addenda, class FROM ".MAIN_DB_PREFIX."cfdixml_addenda WHERE fk_status = 1";
$resql = $db->query($sql);

if ($resql) {
    $num = $db->num_rows($resql);
    if ($num > 0) {
        while ($obj = $db->fetch_object($resql)) {
            print '<tr class="oddeven">';
            print '<td>'.$obj->addenda.'</td>';
            print '<td>'.$obj->class.'</td>';
            print '<td class="right">';
            print '<a class="butActionDelete" href="'.$_SERVER["PHP_SELF"].'?action=deactivate&amp;id='.$obj->rowid.'&token='.newToken().'">'.$langs->trans("Deactivate").'</a>';
            print '</td>';
            print '</tr>';
        }
    } else {
        print '<tr><td colspan="3"><span class="opacitymedium">'.$langs->trans("NoActiveAddendas").'</span></td></tr>';
    }
}

print '</table>';
print '</div>';

print dol_get_fiche_end();

llxFooter();
$db->close();
