<?php

/*
 * View
 */

$title = $langs->trans('Shipping') . ' ' . $object->ref . ' - ' . $langs->trans('Addenda');
$help_url = '';

llxHeader('', $title, $help_url);

// Part to show record
if ($id > 0) {
	$head = shipping_prepare_head($object);
	print dol_get_fiche_head($head, 'addenda', $langs->trans("Shipping"), -1, 'sending');

	// Banner
	$linkback = '<a href="' . DOL_URL_ROOT . '/expedition/list.php?restore_lastsearch_values=1">' . $langs->trans("BackToList") . '</a>';
	$morehtmlref = '<div class="refidno">';
	if (!empty($object->origin) && $object->origin_id > 0) {
		$order = new Commande($db);
		$order->fetch($object->origin_id);
		$morehtmlref .= $order->ref;
	}
	$morehtmlref .= '</div>';
	dol_banner_tab($object, 'ref', $linkback, 1, 'ref', 'ref', $morehtmlref);

	print '<div class="fichecenter">';
	print '<div class="underbanner clearboth"></div>';

	print '<form method="POST" action="' . $_SERVER["PHP_SELF"] . '?elementtype=shipping">';
	print '<input type="hidden" name="token" value="' . newToken() . '">';
	print '<input type="hidden" name="action" value="save">';
	print '<input type="hidden" name="id" value="' . $id . '">';

	print '<table class="border centpercent tableforfield">';

	// Remisión
	print '<tr><td class="titlefieldcreate fieldrequired">' . $langs->trans("Remission") . '</td><td>';
	print '<input type="text" name="remision" value="' . $addendaSoriana->remision . '" class="flat minwidth200">';
	print '</td></tr>';

	// Consecutivo
	print '<tr><td>' . $langs->trans("Consecutive") . '</td><td>';
	print '<input type="text" name="consecutivo" value="' . $addendaSoriana->consecutivo . '" class="flat maxwidth50">';
	print '</td></tr>';

	// Fecha Remisión
	print '<tr><td class="fieldrequired">' . $langs->trans("RemissionDate") . '</td><td>';
	print $form->selectDate($addendaSoriana->fecha_remision ?: dol_now(), 'fecha_remision', 0, 0, 0, '', 1, 1);
	print '</td></tr>';

	// Tipo Bulto
	print '<tr><td class="fieldrequired">' . $langs->trans("PackageType") . '</td><td>';
	print '<input type="text" name="tipo_bulto" value="' . $addendaSoriana->tipo_bulto . '" class="flat maxwidth50">';
	print '</td></tr>';

	// Cantidad Bultos
	print '<tr><td class="fieldrequired">' . $langs->trans("PackageQuantity") . '</td><td>';
	print '<input type="text" name="cantidad_bultos" value="' . $addendaSoriana->cantidad_bultos . '" class="flat maxwidth50">';
	print '</td></tr>';

	// Fecha Entrega
	print '<tr><td class="fieldrequired">' . $langs->trans("DeliveryDate") . '</td><td>';
	print $form->selectDate($addendaSoriana->fecha_entrega ?: dol_now(), 'fecha_entrega', 0, 0, 0, '', 1, 1);
	print '</td></tr>';

	// Empaque Cajas
	print '<tr><td>' . $langs->trans("BoxPacking") . '</td><td>';
	print $form->selectyesno("empaque_cajas", $addendaSoriana->empaque_cajas, 1);
	print '</td></tr>';

	// Empaque Tarimas
	print '<tr><td>' . $langs->trans("PalletPacking") . '</td><td>';
	print $form->selectyesno("empaque_tarimas", $addendaSoriana->empaque_tarimas, 1);
	print '</td></tr>';

	// Cantidad Cajas/Tarimas
	print '<tr><td class="fieldrequired">' . $langs->trans("BoxPalletQuantity") . '</td><td>';
	print '<input type="text" name="cantidad_cajas_tarimas" value="' . $addendaSoriana->cantidad_cajas_tarimas . '" class="flat maxwidth50">';
	print '</td></tr>';

	// Cita
	print '<tr><td class="fieldrequired">' . $langs->trans("Appointment") . '</td><td>';
	print '<input type="text" name="cita" value="' . $addendaSoriana->cita . '" class="flat minwidth200">';
	print '</td></tr>';

	print '</table>';

	print '<div class="center">';
	print '<input type="submit" class="button button-save" value="' . $langs->trans("Save") . '">';
	print '</div>';

	// Después del formulario principal y antes del dol_get_fiche_end()
	print '</form>';

	// Sección de artículos
	print '<br>';
	print load_fiche_titre($langs->trans("Articles"), '', '');

	print '<div class="div-table-responsive-no-min">';
	print '<table class="noborder centpercent">';

	// Cabeceras
	print '<tr class="liste_titre">';
	print '<td>' . $langs->trans("Code") . '</td>';
	print '<td>' . $langs->trans("Label") . '</td>';
	print '<td class="right">' . $langs->trans("Quantity") . '</td>';
	print '<td class="right">' . $langs->trans("UnitPrice") . '</td>';
	print '<td class="right">' . $langs->trans("IEPS") . ' %</td>';
	print '<td class="right">' . $langs->trans("VAT") . ' %</td>';
	print '<td class="right">' . $langs->trans("TotalHT") . '</td>';
	print '</tr>';

	// Detalles de artículos
	if (!empty($object->lines)) {
		foreach ($object->lines as $line) {
			$expeditionDet = new AddendaSorianaExpeditionDet($db);
			$result = $expeditionDet->fetchByExpeditionLine($line->id);

			print '<tr class="oddeven">';

			// Código
			print '<td>' . $line->ref . '</td>';

			// Descripción
			print '<td>' . $line->desc . '</td>';

			// Cantidad
			print '<td class="right">' . price($line->qty) . '</td>';

			// Precio unitario
			print '<td class="right">' . price($line->subprice) . '</td>';

			// IEPS
			print '<td class="right">';
			print ($result > 0) ? price($expeditionDet->porcentaje_ieps) : '0';
			print '</td>';

			// IVA
			print '<td class="right">';
			print ($result > 0) ? price($expeditionDet->porcentaje_iva) : '0';
			print '</td>';

			// Total
			print '<td class="right">' . price($line->total_ht) . '</td>';

			print '</tr>';
		}
	}

	print '</table>';
	print '</div>';

	print dol_get_fiche_end();
}
