<?php
/*
 * View
 */

$title = $langs->trans('Invoice').' '.$object->ref.' - '.$langs->trans('Addenda Soriana');
llxHeader('', $title);

if ($id > 0) {
    $head = facture_prepare_head($object);
    print dol_get_fiche_head($head, 'addenda', $langs->trans("Invoice"), -1, 'bill');

    // Banner
    $linkback = '<a href="'.DOL_URL_ROOT.'/compta/facture/list.php?restore_lastsearch_values=1">'.$langs->trans("BackToList").'</a>';
    $morehtmlref = '<div class="refidno">';

    // Verificar documentos origen
    $hasOrder = false;
    $hasShipment = false;
    $missingFields = array();

    // Verificar pedido origen
    if (!empty($object->origin) && $object->origin == 'commande' && $object->origin_id > 0) {
        require_once DOL_DOCUMENT_ROOT.'/commande/class/commande.class.php';
        $order = new Commande($db);
        $order->fetch($object->origin_id);
        $addendaOrder = new AddendaSorianaCommande($db);
        $addendaOrder->fetchByOrder($order->id);
        $hasOrder = true;
        $morehtmlref .= $langs->trans('Order').': '.$order->ref.'<br>';

        // Verificar campos obligatorios del pedido
        if (empty($addendaOrder->remision)) $missingFields[] = $langs->trans("Remission").' ('.$langs->trans("Order").')';
        if (empty($addendaOrder->folio_pedido)) $missingFields[] = $langs->trans("OrderRef").' ('.$langs->trans("Order").')';
    }

    // Verificar envío relacionado
    $object->fetchObjectLinked();
    if (!empty($object->linkedObjects['shipping'])) {
        require_once DOL_DOCUMENT_ROOT.'/expedition/class/expedition.class.php';
        $shipment = reset($object->linkedObjects['shipping']);
        $addendaShipment = new AddendaSorianaExpedition($db);
        $addendaShipment->fetchByExpedition($shipment->id);
        $hasShipment = true;
        $morehtmlref .= $langs->trans('Shipping').': '.$shipment->ref;

        // Verificar campos obligatorios del envío
        if (empty($addendaShipment->remision)) $missingFields[] = $langs->trans("Remission").' ('.$langs->trans("Shipping").')';
        if (empty($addendaShipment->fecha_remision)) $missingFields[] = $langs->trans("RemissionDate");
        if (empty($addendaShipment->cantidad_bultos)) $missingFields[] = $langs->trans("PackageQuantity");
        if (empty($addendaShipment->fecha_entrega)) $missingFields[] = $langs->trans("DeliveryDate");
        if (empty($addendaShipment->cita)) $missingFields[] = $langs->trans("Appointment");
    }

    $morehtmlref .= '</div>';
    dol_banner_tab($object, 'ref', $linkback, 1, 'ref', 'ref', $morehtmlref);

    // Mostrar advertencia si faltan campos
    if (!empty($missingFields)) {
        print '<div class="warning">';
        print $langs->trans("MissingRequiredFields").': <ul>';
        foreach ($missingFields as $field) {
            print '<li>'.$field.'</li>';
        }
        print '</ul></div>';
    }

    print '<div class="fichecenter">';

    // Información del Pedido
    if ($hasOrder) {
        print load_fiche_titre($langs->trans('OrderInformation'), '', '');
        print '<table class="border centpercent tableforfield">';
        print '<tr><td width="25%" class="titlefield">'.$langs->trans("Remission").'</td><td>'.$addendaOrder->remision.'</td></tr>';
        print '<tr><td>'.$langs->trans("OrderRef").'</td><td>'.$addendaOrder->folio_pedido.'</td></tr>';
        print '<tr><td>'.$langs->trans("ItemQuantity").'</td><td>'.$addendaOrder->cantidad_articulos.'</td></tr>';
        print '</table><br>';
    } else {
        print '<div class="warning">'.$langs->trans("NoOrderFound").'</div>';
    }

    // Información del Envío
    if ($hasShipment) {
        print load_fiche_titre($langs->trans('ShippingInformation'), '', '');
        print '<table class="border centpercent tableforfield">';
        print '<tr><td width="25%" class="titlefield">'.$langs->trans("Remission").'</td><td>'.$addendaShipment->remision.'</td></tr>';
        print '<tr><td>'.$langs->trans("RemissionDate").'</td><td>'.dol_print_date($addendaShipment->fecha_remision, 'dayhour').'</td></tr>';
        print '<tr><td>'.$langs->trans("PackageType").'</td><td>'.$addendaShipment->tipo_bulto.'</td></tr>';
        print '<tr><td>'.$langs->trans("PackageQuantity").'</td><td>'.$addendaShipment->cantidad_bultos.'</td></tr>';
        print '<tr><td>'.$langs->trans("DeliveryDate").'</td><td>'.dol_print_date($addendaShipment->fecha_entrega, 'dayhour').'</td></tr>';
        print '<tr><td>'.$langs->trans("BoxPacking").'</td><td>'.yn($addendaShipment->empaque_cajas).'</td></tr>';
        print '<tr><td>'.$langs->trans("PalletPacking").'</td><td>'.yn($addendaShipment->empaque_tarimas).'</td></tr>';
        print '<tr><td>'.$langs->trans("BoxPalletQuantity").'</td><td>'.$addendaShipment->cantidad_cajas_tarimas.'</td></tr>';
        print '<tr><td>'.$langs->trans("Appointment").'</td><td>'.$addendaShipment->cita.'</td></tr>';
        print '</table><br>';

        // Detalles de los artículos
        print load_fiche_titre($langs->trans('Articles'), '', '');
        print '<div class="div-table-responsive-no-min">';
        print '<table class="noborder centpercent">';
        print '<tr class="liste_titre">';
        print '<td>'.$langs->trans("Code").'</td>';
        print '<td>'.$langs->trans("Label").'</td>';
        print '<td class="right">'.$langs->trans("Quantity").'</td>';
        print '<td class="right">'.$langs->trans("UnitPrice").'</td>';
        print '<td class="right">'.$langs->trans("IEPS").' %</td>';
        print '<td class="right">'.$langs->trans("VAT").' %</td>';
        print '<td class="right">'.$langs->trans("TotalHT").'</td>';
        print '</tr>';

        if ($shipment && $shipment->lines) {
            foreach ($shipment->lines as $line) {
                $expeditionDet = new AddendaSorianaExpeditionDet($db);
                if ($expeditionDet->fetchByExpeditionLine($line->id) > 0) {
                    print '<tr class="oddeven">';
                    print '<td>'.$expeditionDet->codigo.'</td>';
                    print '<td>'.$line->description.'</td>';
                    print '<td class="right">'.price($expeditionDet->cantidad_unidad).'</td>';
                    print '<td class="right">'.price($expeditionDet->costo_neto).'</td>';
                    print '<td class="right">'.price($expeditionDet->porcentaje_ieps).'</td>';
                    print '<td class="right">'.price($expeditionDet->porcentaje_iva).'</td>';
                    print '<td class="right">'.price($expeditionDet->cantidad_unidad * $expeditionDet->costo_neto).'</td>';
                    print '</tr>';
                }
            }
        }
        print '</table>';
        print '</div>';
    } else {
        print '<div class="warning">'.$langs->trans("NoShipmentFound").'</div>';
    }

    print '</div>';
    print dol_get_fiche_end();
}
