<?php
/* Copyright (C) 2001-2005 Rodolphe Quiedeville <rodolphe@quiedeville.org>
 * Copyright (C) 2004-2015 Laurent Destailleur  <eldy@users.sourceforge.net>
 * Copyright (C) 2005-2012 Regis Houssin        <regis.houssin@inodbox.com>
 * Copyright (C) 2015      Jean-François Ferry	<jfefe@aternatik.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

// Load Dolibarr environment
$res = 0;
// Try main.inc.php into web root known defined into CONTEXT_DOCUMENT_ROOT (not always defined)
if (!$res && !empty($_SERVER["CONTEXT_DOCUMENT_ROOT"])) {
	$res = @include $_SERVER["CONTEXT_DOCUMENT_ROOT"] . "/main.inc.php";
}
// Try main.inc.php into web root detected using web root calculated from SCRIPT_FILENAME
$tmp = empty($_SERVER['SCRIPT_FILENAME']) ? '' : $_SERVER['SCRIPT_FILENAME'];
$tmp2 = realpath(__FILE__);
$i = strlen($tmp) - 1;
$j = strlen($tmp2) - 1;
while ($i > 0 && $j > 0 && isset($tmp[$i]) && isset($tmp2[$j]) && $tmp[$i] == $tmp2[$j]) {
	$i--;
	$j--;
}
if (!$res && $i > 0 && file_exists(substr($tmp, 0, ($i + 1)) . "/main.inc.php")) {
	$res = @include substr($tmp, 0, ($i + 1)) . "/main.inc.php";
}
if (!$res && $i > 0 && file_exists(dirname(substr($tmp, 0, ($i + 1))) . "/main.inc.php")) {
	$res = @include dirname(substr($tmp, 0, ($i + 1))) . "/main.inc.php";
}
// Try main.inc.php using relative path
if (!$res && file_exists("../main.inc.php")) {
	$res = @include "../main.inc.php";
}
if (!$res && file_exists("../../main.inc.php")) {
	$res = @include "../../main.inc.php";
}
if (!$res && file_exists("../../../main.inc.php")) {
	$res = @include "../../../main.inc.php";
}
if (!$res) {
	die("Include of main fails");
}

require_once DOL_DOCUMENT_ROOT . '/core/lib/functions2.lib.php';
require_once DOL_DOCUMENT_ROOT . '/commande/class/commande.class.php';
require_once DOL_DOCUMENT_ROOT . '/expedition/class/expedition.class.php';
require_once DOL_DOCUMENT_ROOT . '/compta/facture/class/facture.class.php';
require_once DOL_DOCUMENT_ROOT . '/core/class/html.form.class.php';


$elementtype = GETPOST('elementtype', 'alpha');
$id = GETPOST('id', 'int');
$action = GETPOST('action', 'aZ09');

// TODO: obtener id, luego el socid y verificar que tipo de addenda tiene asiganda para luego cargar los datos
// TODO: por ahora solo carga soriana.
$langs->loadLangs(array('cfdixml@cfdixml', 'orders'));

$form = new Form($db);

// Después de la carga de clases
$error = 0;

// Validación común para todos los tipos
if ($elementtype == 'order') {
	$object = new Commande($db);
} elseif ($elementtype == 'shipping') {
	$object = new Expedition($db);
} elseif ($elementtype == 'invoice') {
	$object = new Facture($db);
} else {
	accessforbidden('ElementType not supported');
}

// Cargar el objeto
$result = $object->fetch($id);
if ($result < 0) {
	accessforbidden();
}

// Obtener el tipo de addenda del tercero (desde extrafields)
$object->fetch_thirdparty();
$addendaTypeId = $object->thirdparty->array_options['options_type_addenda'];

if (empty($addendaTypeId)) {
	accessforbidden($langs->trans("ThirdPartyHasNoAddenda"));
}

// Cargar la configuración de la addenda
$sql = "SELECT rowid, addenda, class FROM " . MAIN_DB_PREFIX . "cfdixml_addenda WHERE rowid = " . (int)$addendaTypeId . " AND fk_status = 1";
$resql = $db->query($sql);
if ($resql && ($obj = $db->fetch_object($resql))) {
	$addendaType = $obj->addenda;
	$addendaClass = $obj->class;
	$addendaarr = explode(':', $addendaClass);
} else {
	accessforbidden($langs->trans("AddendaNotFoundOrInactive"));
}

// Cargar la vista correspondiente según el tipo de addenda
switch (strtolower($addendaType)) {
	case 'soriana':
		dol_include_once($addendaarr[1]);
		if ($elementtype == 'order') {

			$addendaSoriana = new AddendaSorianaCommande($db);
			$addendaSoriana->remision = $object->ref_client;

			if ($action == 'save') {
				$addendaSoriana->fk_commande = GETPOST('id', 'int');

				$addendaSoriana->folio_pedido = GETPOST('folio_pedido', 'alpha');
				$addendaSoriana->cantidad_articulos = 1; //TODO: hacerlo dinámico según los campos de la addenda Soriana

				// Validación y procesamiento del formulario de addenda Soriana para la orden
				$error = $addendaSoriana->create($user, 1);
				if ($error < 0) {
					$error = $addendaSoriana->update($user, 1);
					if ($error < 0) {
						setEventMessage($langs->trans("ErrorWhileSavingAddenda"), 'error');
						header('Location: ' . $_SERVER['PHP_SELF'] . '?id=' . $id . '&elementtype=' . $elementtype);
						exit;
					}

				}
			} else {
				$addendaSoriana->fetchByOrder($id);
			}
			require_once DOL_DOCUMENT_ROOT . '/core/lib/order.lib.php';


			$langs->loadLangs(array('cfdixml@cfdixml', 'orders'));
			include __DIR__ . '/soriana/order.php';
		} elseif ($elementtype == 'shipping') {

			require_once DOL_DOCUMENT_ROOT . '/core/lib/sendings.lib.php';
			$addendaSoriana = new AddendaSorianaExpedition($db);
			$addendaSoriana->remision = $object->ref_customer;
			$langs->loadLangs(array('cfdixml@cfdixml', 'sendings'));
			if ($action == 'save') {

				$addendaSoriana->fk_expedition = GETPOST('id', 'int');
				$addendaSoriana->consecutivo = GETPOST('consecutivo', 'alpha');
				$addendaSoriana->fecha_remision = dol_mktime(12, 0, 0, GETPOSTINT('fecha_remisionmonth'), GETPOSTINT('fecha_remisionday'), GETPOSTINT('fecha_remisionyear'));

				$addendaSoriana->fecha_entrega = dol_mktime(12, 0, 0, GETPOSTINT('fecha_entregamonth'), GETPOSTINT('fecha_entregaday'), GETPOSTINT('fecha_entregayear'));
				$addendaSoriana->tipo_bulto = GETPOST('tipo_bulto', 'alpha');
				$addendaSoriana->cantidad_bultos = GETPOST('cantidad_bultos', 'alpha');
				$addendaSoriana->empaque_cajas = GETPOST('empaque_cajas', 'int');
				$addendaSoriana->empaque_tarimas = GETPOST('empaque_tarimas', 'int');
				$addendaSoriana->cantidad_cajas_tarimas = GETPOST('cantidad_cajas_tarimas', 'int');
				$addendaSoriana->cita = GETPOST('cita', 'alpha');

				$error = $addendaSoriana->create($user, 1);
//				echo $error;
				if ($error < 0) {
					$addendaSoriana->fetchByExpedition($id);
					$addendaSoriana->fk_expedition = GETPOST('id', 'int');
					$addendaSoriana->consecutivo = GETPOST('consecutivo', 'alpha');
					$addendaSoriana->fecha_remision = dol_mktime(12, 0, 0, GETPOSTINT('fecha_remisionmonth'), GETPOSTINT('fecha_remisionday'), GETPOSTINT('fecha_remisionyear'));

					$addendaSoriana->fecha_entrega = dol_mktime(12, 0, 0, GETPOSTINT('fecha_entregamonth'), GETPOSTINT('fecha_entregaday'), GETPOSTINT('fecha_entregayear'));
					$addendaSoriana->tipo_bulto = GETPOST('tipo_bulto', 'alpha');
					$addendaSoriana->cantidad_bultos = GETPOST('cantidad_bultos', 'alpha');
					$addendaSoriana->empaque_cajas = GETPOST('empaque_cajas', 'int');
					$addendaSoriana->empaque_tarimas = GETPOST('empaque_tarimas', 'int');
					$addendaSoriana->cantidad_cajas_tarimas = GETPOST('cantidad_cajas_tarimas', 'int');
					$addendaSoriana->cita = GETPOST('cita', 'alpha');
					$error = $addendaSoriana->update($user, 1);
					if ($error < 0) {
						header('Location: ' . $_SERVER['PHP_SELF'] . '?id=' . $id . '&elementtype=' . $elementtype);
						exit;
					}
				}

			} else {
				$addendaSoriana->fetchByExpedition($id);
			}

			include __DIR__ . '/soriana/shipping.php';
		} elseif ($elementtype == 'invoice') {

			require_once DOL_DOCUMENT_ROOT . '/core/lib/invoice.lib.php';
			$langs->loadLangs(array('cfdixml@cfdixml', 'bills'));
			include __DIR__ . '/soriana/invoice.php';
		}
		break;

	case 'chedraui':
		// Similar estructura para Chedraui
		include __DIR__ . '/chedraui/' . $elementtype . '.php';
		break;

	case 'walmart':
		// Similar estructura para Walmart
		include __DIR__ . '/walmart/' . $elementtype . '.php';
		break;

	case 'zf':
		// Similar estructura para ZF
		include __DIR__ . '/zf/' . $elementtype . '.php';
		break;

	default:
		accessforbidden($langs->trans("AddendaTypeNotSupported"));
		break;
}
// End of page
llxFooter();
$db->close();
