# CHANGELOG

## [2.0.10] - 2025-01-30
### Añadido
- Implementación inicial del módulo
- Soporte para CFDI 4.0
- Complemento de Comercio Exterior 2.0
- Sistema de manejo de catálogos SAT
- Validación XSD
- Manejo de certificados
- Soporte para impuestos
- Manejo de addendas y complementos

### Funcionalidades Clave
- Generación de CFDI con complemento de comercio exterior
- Manejo de productos y servicios
- Soporte para múltiples impuestos
- Validación de domicilios nacionales e internacionales
- Cálculo automático de totales en USD
- Soporte para fracciones arancelarias
- Manejo de unidades de aduana

### Mejoras Técnicas
- Implementación de sistema de catálogos en SQLite
- Manejo modular de complementos
- Sistema de validación XSD
- Manejo de errores y excepciones
- Logging detallado de operaciones

### Correcciones
- Manejo correcto de ObjetoImp en conceptos
- Validación de países según catálogo del SAT
- Corrección en el manejo de impuestos a tasa 0%
- Ajuste en el formato de importes y cantidades

## Próximas Características Planeadas
- Soporte para carta porte
- Manejo de cancelaciones automáticas
- Interfaz mejorada para configuración
- Sistema de respaldo de XMLs
- Reportes y estadísticas


### Complete ✅
- **Base Structure**
 - CFDI40Generator base class
 - Base XML generation
 - Namespace handling
 - Required/optional attributes 

- **Certificates & Sealing**
 - Certificate class (.cer/.key)
 - Automatic PEM conversion
 - Certificate serial processing
 - Certificate data extraction
 - Digital seal generation

- **Validation & Structure** 
 - CFDIParametrosValidator
 - XSLTParser schema processing
 - CFDI structure validation
 - Required fields validation

- **Main Nodes**
 - Emisor node
 - Receptor node
 - Initial Concepts structure
 - Basic tax handling

### In Development 🔄 (Nov 25, 2024)
- Concepts handling restructure
- Tax implementation in Concepts
 - Transfers at concept level 
 - Withholdings at concept level
 - Global tax accumulation
- Pre-stamping tax validation
- PAC integration (Finkok)

### Pending ⏳
- Complements
- Cancellation process
- Documentation
- Unit tests 
- Specific business validations

### Next Steps
1. Complete tax implementation
2. PAC stamping tests
3. PAC response handling
4. Cancellation implementation

### Dependencies
- PHP 7+
- OpenSSL
- DOM/XSLT 
- SOAP
